/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteCoachingAppointmentAnnotationRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteCoachingAppointmentRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingAppointmentAnnotationRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingAppointmentAnnotationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingAppointmentRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingAppointmentStatusesRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingAppointmentsMeRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingAppointmentsRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingNotificationRequest;
import com.mypurecloud.sdk.v2.api.request.GetCoachingNotificationsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchCoachingAppointmentAnnotationRequest;
import com.mypurecloud.sdk.v2.api.request.PatchCoachingAppointmentRequest;
import com.mypurecloud.sdk.v2.api.request.PatchCoachingAppointmentStatusRequest;
import com.mypurecloud.sdk.v2.api.request.PatchCoachingNotificationRequest;
import com.mypurecloud.sdk.v2.api.request.PostCoachingAppointmentAnnotationsRequest;
import com.mypurecloud.sdk.v2.api.request.PostCoachingAppointmentsRequest;
import com.mypurecloud.sdk.v2.model.CoachingAnnotation;
import com.mypurecloud.sdk.v2.model.CoachingAnnotationCreateRequest;
import com.mypurecloud.sdk.v2.model.CoachingAnnotationList;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentReference;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentResponse;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentResponseList;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentStatusDto;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentStatusDtoList;
import com.mypurecloud.sdk.v2.model.CoachingNotification;
import com.mypurecloud.sdk.v2.model.CoachingNotificationList;
import com.mypurecloud.sdk.v2.model.CreateCoachingAppointmentRequest;
import com.mypurecloud.sdk.v2.model.UpdateCoachingAppointmentRequest;
import java.io.IOException;
import java.util.List;

public class CoachingApi {
    private final ApiClient pcapiClient;

    public CoachingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CoachingApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public CoachingAppointmentReference deleteCoachingAppointment(String appointmentId) throws IOException, ApiException {
        return this.deleteCoachingAppointment(this.createDeleteCoachingAppointmentRequest(appointmentId));
    }

    public ApiResponse<CoachingAppointmentReference> deleteCoachingAppointmentWithHttpInfo(String appointmentId) throws IOException {
        return this.deleteCoachingAppointment(this.createDeleteCoachingAppointmentRequest(appointmentId).withHttpInfo());
    }

    private DeleteCoachingAppointmentRequest createDeleteCoachingAppointmentRequest(String appointmentId) {
        return DeleteCoachingAppointmentRequest.builder().withAppointmentId(appointmentId).build();
    }

    public CoachingAppointmentReference deleteCoachingAppointment(DeleteCoachingAppointmentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentReference> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentReference>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentReference> deleteCoachingAppointment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentReference>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteCoachingAppointmentAnnotation(String appointmentId, String annotationId) throws IOException, ApiException {
        this.deleteCoachingAppointmentAnnotation(this.createDeleteCoachingAppointmentAnnotationRequest(appointmentId, annotationId));
    }

    public ApiResponse<Void> deleteCoachingAppointmentAnnotationWithHttpInfo(String appointmentId, String annotationId) throws IOException {
        return this.deleteCoachingAppointmentAnnotation(this.createDeleteCoachingAppointmentAnnotationRequest(appointmentId, annotationId).withHttpInfo());
    }

    private DeleteCoachingAppointmentAnnotationRequest createDeleteCoachingAppointmentAnnotationRequest(String appointmentId, String annotationId) {
        return DeleteCoachingAppointmentAnnotationRequest.builder().withAppointmentId(appointmentId).withAnnotationId(annotationId).build();
    }

    public void deleteCoachingAppointmentAnnotation(DeleteCoachingAppointmentAnnotationRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteCoachingAppointmentAnnotation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentResponse getCoachingAppointment(String appointmentId) throws IOException, ApiException {
        return this.getCoachingAppointment(this.createGetCoachingAppointmentRequest(appointmentId));
    }

    public ApiResponse<CoachingAppointmentResponse> getCoachingAppointmentWithHttpInfo(String appointmentId) throws IOException {
        return this.getCoachingAppointment(this.createGetCoachingAppointmentRequest(appointmentId).withHttpInfo());
    }

    private GetCoachingAppointmentRequest createGetCoachingAppointmentRequest(String appointmentId) {
        return GetCoachingAppointmentRequest.builder().withAppointmentId(appointmentId).build();
    }

    public CoachingAppointmentResponse getCoachingAppointment(GetCoachingAppointmentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentResponse> getCoachingAppointment(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAnnotation getCoachingAppointmentAnnotation(String appointmentId, String annotationId) throws IOException, ApiException {
        return this.getCoachingAppointmentAnnotation(this.createGetCoachingAppointmentAnnotationRequest(appointmentId, annotationId));
    }

    public ApiResponse<CoachingAnnotation> getCoachingAppointmentAnnotationWithHttpInfo(String appointmentId, String annotationId) throws IOException {
        return this.getCoachingAppointmentAnnotation(this.createGetCoachingAppointmentAnnotationRequest(appointmentId, annotationId).withHttpInfo());
    }

    private GetCoachingAppointmentAnnotationRequest createGetCoachingAppointmentAnnotationRequest(String appointmentId, String annotationId) {
        return GetCoachingAppointmentAnnotationRequest.builder().withAppointmentId(appointmentId).withAnnotationId(annotationId).build();
    }

    public CoachingAnnotation getCoachingAppointmentAnnotation(GetCoachingAppointmentAnnotationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAnnotation> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAnnotation>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAnnotation> getCoachingAppointmentAnnotation(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAnnotation>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAnnotationList getCoachingAppointmentAnnotations(String appointmentId, Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.getCoachingAppointmentAnnotations(this.createGetCoachingAppointmentAnnotationsRequest(appointmentId, pageNumber, pageSize));
    }

    public ApiResponse<CoachingAnnotationList> getCoachingAppointmentAnnotationsWithHttpInfo(String appointmentId, Integer pageNumber, Integer pageSize) throws IOException {
        return this.getCoachingAppointmentAnnotations(this.createGetCoachingAppointmentAnnotationsRequest(appointmentId, pageNumber, pageSize).withHttpInfo());
    }

    private GetCoachingAppointmentAnnotationsRequest createGetCoachingAppointmentAnnotationsRequest(String appointmentId, Integer pageNumber, Integer pageSize) {
        return GetCoachingAppointmentAnnotationsRequest.builder().withAppointmentId(appointmentId).withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public CoachingAnnotationList getCoachingAppointmentAnnotations(GetCoachingAppointmentAnnotationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAnnotationList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAnnotationList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAnnotationList> getCoachingAppointmentAnnotations(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAnnotationList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentStatusDtoList getCoachingAppointmentStatuses(String appointmentId, Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.getCoachingAppointmentStatuses(this.createGetCoachingAppointmentStatusesRequest(appointmentId, pageNumber, pageSize));
    }

    public ApiResponse<CoachingAppointmentStatusDtoList> getCoachingAppointmentStatusesWithHttpInfo(String appointmentId, Integer pageNumber, Integer pageSize) throws IOException {
        return this.getCoachingAppointmentStatuses(this.createGetCoachingAppointmentStatusesRequest(appointmentId, pageNumber, pageSize).withHttpInfo());
    }

    private GetCoachingAppointmentStatusesRequest createGetCoachingAppointmentStatusesRequest(String appointmentId, Integer pageNumber, Integer pageSize) {
        return GetCoachingAppointmentStatusesRequest.builder().withAppointmentId(appointmentId).withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public CoachingAppointmentStatusDtoList getCoachingAppointmentStatuses(GetCoachingAppointmentStatusesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentStatusDtoList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentStatusDtoList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentStatusDtoList> getCoachingAppointmentStatuses(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentStatusDtoList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentResponseList getCoachingAppointments(List<String> userIds, String interval, Integer pageNumber, Integer pageSize, List<String> statuses, List<String> facilitatorIds, String sortOrder) throws IOException, ApiException {
        return this.getCoachingAppointments(this.createGetCoachingAppointmentsRequest(userIds, interval, pageNumber, pageSize, statuses, facilitatorIds, sortOrder));
    }

    public ApiResponse<CoachingAppointmentResponseList> getCoachingAppointmentsWithHttpInfo(List<String> userIds, String interval, Integer pageNumber, Integer pageSize, List<String> statuses, List<String> facilitatorIds, String sortOrder) throws IOException {
        return this.getCoachingAppointments(this.createGetCoachingAppointmentsRequest(userIds, interval, pageNumber, pageSize, statuses, facilitatorIds, sortOrder).withHttpInfo());
    }

    private GetCoachingAppointmentsRequest createGetCoachingAppointmentsRequest(List<String> userIds, String interval, Integer pageNumber, Integer pageSize, List<String> statuses, List<String> facilitatorIds, String sortOrder) {
        return GetCoachingAppointmentsRequest.builder().withUserIds(userIds).withInterval(interval).withPageNumber(pageNumber).withPageSize(pageSize).withStatuses(statuses).withFacilitatorIds(facilitatorIds).withSortOrder(sortOrder).build();
    }

    public CoachingAppointmentResponseList getCoachingAppointments(GetCoachingAppointmentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentResponseList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentResponseList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentResponseList> getCoachingAppointments(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentResponseList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentResponseList getCoachingAppointmentsMe(String interval, Integer pageNumber, Integer pageSize, List<String> statuses, List<String> facilitatorIds, String sortOrder) throws IOException, ApiException {
        return this.getCoachingAppointmentsMe(this.createGetCoachingAppointmentsMeRequest(interval, pageNumber, pageSize, statuses, facilitatorIds, sortOrder));
    }

    public ApiResponse<CoachingAppointmentResponseList> getCoachingAppointmentsMeWithHttpInfo(String interval, Integer pageNumber, Integer pageSize, List<String> statuses, List<String> facilitatorIds, String sortOrder) throws IOException {
        return this.getCoachingAppointmentsMe(this.createGetCoachingAppointmentsMeRequest(interval, pageNumber, pageSize, statuses, facilitatorIds, sortOrder).withHttpInfo());
    }

    private GetCoachingAppointmentsMeRequest createGetCoachingAppointmentsMeRequest(String interval, Integer pageNumber, Integer pageSize, List<String> statuses, List<String> facilitatorIds, String sortOrder) {
        return GetCoachingAppointmentsMeRequest.builder().withInterval(interval).withPageNumber(pageNumber).withPageSize(pageSize).withStatuses(statuses).withFacilitatorIds(facilitatorIds).withSortOrder(sortOrder).build();
    }

    public CoachingAppointmentResponseList getCoachingAppointmentsMe(GetCoachingAppointmentsMeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentResponseList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentResponseList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentResponseList> getCoachingAppointmentsMe(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentResponseList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingNotification getCoachingNotification(String notificationId, List<String> expand) throws IOException, ApiException {
        return this.getCoachingNotification(this.createGetCoachingNotificationRequest(notificationId, expand));
    }

    public ApiResponse<CoachingNotification> getCoachingNotificationWithHttpInfo(String notificationId, List<String> expand) throws IOException {
        return this.getCoachingNotification(this.createGetCoachingNotificationRequest(notificationId, expand).withHttpInfo());
    }

    private GetCoachingNotificationRequest createGetCoachingNotificationRequest(String notificationId, List<String> expand) {
        return GetCoachingNotificationRequest.builder().withNotificationId(notificationId).withExpand(expand).build();
    }

    public CoachingNotification getCoachingNotification(GetCoachingNotificationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingNotification> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingNotification>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingNotification> getCoachingNotification(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingNotification>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingNotificationList getCoachingNotifications(Integer pageNumber, Integer pageSize, List<String> expand) throws IOException, ApiException {
        return this.getCoachingNotifications(this.createGetCoachingNotificationsRequest(pageNumber, pageSize, expand));
    }

    public ApiResponse<CoachingNotificationList> getCoachingNotificationsWithHttpInfo(Integer pageNumber, Integer pageSize, List<String> expand) throws IOException {
        return this.getCoachingNotifications(this.createGetCoachingNotificationsRequest(pageNumber, pageSize, expand).withHttpInfo());
    }

    private GetCoachingNotificationsRequest createGetCoachingNotificationsRequest(Integer pageNumber, Integer pageSize, List<String> expand) {
        return GetCoachingNotificationsRequest.builder().withPageNumber(pageNumber).withPageSize(pageSize).withExpand(expand).build();
    }

    public CoachingNotificationList getCoachingNotifications(GetCoachingNotificationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingNotificationList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingNotificationList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingNotificationList> getCoachingNotifications(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingNotificationList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentResponse patchCoachingAppointment(String appointmentId, UpdateCoachingAppointmentRequest body) throws IOException, ApiException {
        return this.patchCoachingAppointment(this.createPatchCoachingAppointmentRequest(appointmentId, body));
    }

    public ApiResponse<CoachingAppointmentResponse> patchCoachingAppointmentWithHttpInfo(String appointmentId, UpdateCoachingAppointmentRequest body) throws IOException {
        return this.patchCoachingAppointment(this.createPatchCoachingAppointmentRequest(appointmentId, body).withHttpInfo());
    }

    private PatchCoachingAppointmentRequest createPatchCoachingAppointmentRequest(String appointmentId, UpdateCoachingAppointmentRequest body) {
        return PatchCoachingAppointmentRequest.builder().withAppointmentId(appointmentId).withBody(body).build();
    }

    public CoachingAppointmentResponse patchCoachingAppointment(PatchCoachingAppointmentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentResponse> patchCoachingAppointment(ApiRequest<UpdateCoachingAppointmentRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAnnotation patchCoachingAppointmentAnnotation(String appointmentId, String annotationId, CoachingAnnotation body) throws IOException, ApiException {
        return this.patchCoachingAppointmentAnnotation(this.createPatchCoachingAppointmentAnnotationRequest(appointmentId, annotationId, body));
    }

    public ApiResponse<CoachingAnnotation> patchCoachingAppointmentAnnotationWithHttpInfo(String appointmentId, String annotationId, CoachingAnnotation body) throws IOException {
        return this.patchCoachingAppointmentAnnotation(this.createPatchCoachingAppointmentAnnotationRequest(appointmentId, annotationId, body).withHttpInfo());
    }

    private PatchCoachingAppointmentAnnotationRequest createPatchCoachingAppointmentAnnotationRequest(String appointmentId, String annotationId, CoachingAnnotation body) {
        return PatchCoachingAppointmentAnnotationRequest.builder().withAppointmentId(appointmentId).withAnnotationId(annotationId).withBody(body).build();
    }

    public CoachingAnnotation patchCoachingAppointmentAnnotation(PatchCoachingAppointmentAnnotationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAnnotation> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAnnotation>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAnnotation> patchCoachingAppointmentAnnotation(ApiRequest<CoachingAnnotation> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAnnotation>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentStatusDto patchCoachingAppointmentStatus(String appointmentId, CoachingAppointmentStatusDto body) throws IOException, ApiException {
        return this.patchCoachingAppointmentStatus(this.createPatchCoachingAppointmentStatusRequest(appointmentId, body));
    }

    public ApiResponse<CoachingAppointmentStatusDto> patchCoachingAppointmentStatusWithHttpInfo(String appointmentId, CoachingAppointmentStatusDto body) throws IOException {
        return this.patchCoachingAppointmentStatus(this.createPatchCoachingAppointmentStatusRequest(appointmentId, body).withHttpInfo());
    }

    private PatchCoachingAppointmentStatusRequest createPatchCoachingAppointmentStatusRequest(String appointmentId, CoachingAppointmentStatusDto body) {
        return PatchCoachingAppointmentStatusRequest.builder().withAppointmentId(appointmentId).withBody(body).build();
    }

    public CoachingAppointmentStatusDto patchCoachingAppointmentStatus(PatchCoachingAppointmentStatusRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentStatusDto> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentStatusDto>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentStatusDto> patchCoachingAppointmentStatus(ApiRequest<CoachingAppointmentStatusDto> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentStatusDto>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingNotification patchCoachingNotification(String notificationId, CoachingNotification body) throws IOException, ApiException {
        return this.patchCoachingNotification(this.createPatchCoachingNotificationRequest(notificationId, body));
    }

    public ApiResponse<CoachingNotification> patchCoachingNotificationWithHttpInfo(String notificationId, CoachingNotification body) throws IOException {
        return this.patchCoachingNotification(this.createPatchCoachingNotificationRequest(notificationId, body).withHttpInfo());
    }

    private PatchCoachingNotificationRequest createPatchCoachingNotificationRequest(String notificationId, CoachingNotification body) {
        return PatchCoachingNotificationRequest.builder().withNotificationId(notificationId).withBody(body).build();
    }

    public CoachingNotification patchCoachingNotification(PatchCoachingNotificationRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingNotification> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingNotification>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingNotification> patchCoachingNotification(ApiRequest<CoachingNotification> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingNotification>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAnnotation postCoachingAppointmentAnnotations(String appointmentId, CoachingAnnotationCreateRequest body) throws IOException, ApiException {
        return this.postCoachingAppointmentAnnotations(this.createPostCoachingAppointmentAnnotationsRequest(appointmentId, body));
    }

    public ApiResponse<CoachingAnnotation> postCoachingAppointmentAnnotationsWithHttpInfo(String appointmentId, CoachingAnnotationCreateRequest body) throws IOException {
        return this.postCoachingAppointmentAnnotations(this.createPostCoachingAppointmentAnnotationsRequest(appointmentId, body).withHttpInfo());
    }

    private PostCoachingAppointmentAnnotationsRequest createPostCoachingAppointmentAnnotationsRequest(String appointmentId, CoachingAnnotationCreateRequest body) {
        return PostCoachingAppointmentAnnotationsRequest.builder().withAppointmentId(appointmentId).withBody(body).build();
    }

    public CoachingAnnotation postCoachingAppointmentAnnotations(PostCoachingAppointmentAnnotationsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAnnotation> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAnnotation>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAnnotation> postCoachingAppointmentAnnotations(ApiRequest<CoachingAnnotationCreateRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAnnotation>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CoachingAppointmentResponse postCoachingAppointments(CreateCoachingAppointmentRequest body) throws IOException, ApiException {
        return this.postCoachingAppointments(this.createPostCoachingAppointmentsRequest(body));
    }

    public ApiResponse<CoachingAppointmentResponse> postCoachingAppointmentsWithHttpInfo(CreateCoachingAppointmentRequest body) throws IOException {
        return this.postCoachingAppointments(this.createPostCoachingAppointmentsRequest(body).withHttpInfo());
    }

    private PostCoachingAppointmentsRequest createPostCoachingAppointmentsRequest(CreateCoachingAppointmentRequest body) {
        return PostCoachingAppointmentsRequest.builder().withBody(body).build();
    }

    public CoachingAppointmentResponse postCoachingAppointments(PostCoachingAppointmentsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CoachingAppointmentResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CoachingAppointmentResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CoachingAppointmentResponse> postCoachingAppointments(ApiRequest<CreateCoachingAppointmentRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CoachingAppointmentResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

