/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Conversation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PostConversationsCallParticipantsRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String callId;
    private Conversation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public PostConversationsCallParticipantsRequest withCallId(String callId) {
        this.setCallId(callId);
        return this;
    }

    public Conversation getBody() {
        return this.body;
    }

    public void setBody(Conversation body) {
        this.body = body;
    }

    public PostConversationsCallParticipantsRequest withBody(Conversation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsCallParticipantsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Conversation> withHttpInfo() throws ApiException {
        if (this.callId == null) {
            throw new ApiException(400, "Missing the required parameter 'callId' when building request for PostConversationsCallParticipantsRequest.");
        }
        if (this.body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when building request for PostConversationsCallParticipantsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/calls/{callId}/participants").withPathParameter("callId", this.callId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callId, Conversation body) {
        return new Builder().withRequiredParams(callId, body);
    }

    public static class Builder {
        private final PostConversationsCallParticipantsRequest request = new PostConversationsCallParticipantsRequest();

        private Builder() {
        }

        public Builder withCallId(String callId) {
            this.request.setCallId(callId);
            return this;
        }

        public Builder withBody(Conversation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String callId, Conversation body) {
            this.request.setCallId(callId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsCallParticipantsRequest build() {
            return this.request;
        }
    }
}

