/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring;

import java.util.Date;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionTimedOutException;

public final class TimeoutHolder {
    private static final ThreadLocal<Long> TRANSACTION_DEADLINE = new ThreadLocal();

    public static void hold(TransactionDefinition definition) {
        if (definition == null) {
            return;
        }
        int timeout = definition.getTimeout();
        if (timeout != -1) {
            Long deadline = System.currentTimeMillis() + (long)timeout * 1000L;
            TRANSACTION_DEADLINE.set(deadline);
        }
    }

    public static void clear() {
        TRANSACTION_DEADLINE.remove();
    }

    public static Integer getTimeToLiveInSeconds() {
        Long deadline = TRANSACTION_DEADLINE.get();
        if (deadline == null) {
            return null;
        }
        double diff = (double)TimeoutHolder.getTimeToLiveInMillis(deadline) / 1000.0;
        int secs = (int)Math.ceil(diff);
        TimeoutHolder.checkTransactionTimeout(secs <= 0, deadline);
        return secs;
    }

    private static void checkTransactionTimeout(boolean deadlineReached, Long deadline) throws TransactionTimedOutException {
        if (deadlineReached) {
            throw new TransactionTimedOutException("Transaction timed out: deadline was " + new Date(deadline));
        }
    }

    private static long getTimeToLiveInMillis(Long deadline) throws TransactionTimedOutException {
        if (deadline == null) {
            throw new IllegalStateException("No timeout specified for this resource holder");
        }
        long timeToLive = deadline - System.currentTimeMillis();
        TimeoutHolder.checkTransactionTimeout(timeToLive <= 0L, deadline);
        return timeToLive;
    }
}

