/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.boot;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Conditional(value={OnMybatisFlexDataSourceCondition.class})
public @interface ConditionalOnMybatisFlexDatasource {

    @Order(value=-2147483648)
    public static class OnMybatisFlexDataSourceCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment env = context.getEnvironment();
            if (env instanceof AbstractEnvironment) {
                MutablePropertySources propertySources = ((AbstractEnvironment)env).getPropertySources();
                Iterator it = propertySources.stream().iterator();
                while (it.hasNext()) {
                    PropertySource ps = (PropertySource)it.next();
                    if (!(ps instanceof EnumerablePropertySource)) continue;
                    for (String propertyName : ((EnumerablePropertySource)ps).getPropertyNames()) {
                        if (!propertyName.startsWith("mybatis-flex.datasource.")) continue;
                        return ConditionOutcome.match();
                    }
                }
            }
            return ConditionOutcome.noMatch((String)"'mybatis-flex.datasource' is necessary.");
        }
    }
}

