/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.base.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.LogDTO;
import org.jeecg.common.system.base.mapper.BaseCommonMapper;
import org.jeecg.common.system.base.service.BaseCommonService;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.IPUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.springframework.stereotype.Service;

@Service
public class BaseCommonServiceImpl
implements BaseCommonService {
    @Resource
    private BaseCommonMapper baseCommonMapper;

    @Override
    public void addLog(LogDTO logDTO) {
        if (oConvertUtils.isEmpty(logDTO.getId())) {
            logDTO.setId(String.valueOf(IdWorker.getId()));
        }
        this.baseCommonMapper.saveLog(logDTO);
    }

    @Override
    public void addLog(String logContent, Integer logType, Integer operatetype, LoginUser user) {
        LogDTO sysLog = new LogDTO();
        sysLog.setId(String.valueOf(IdWorker.getId()));
        sysLog.setLogContent(logContent);
        sysLog.setLogType(logType);
        sysLog.setOperateType(operatetype);
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            sysLog.setIp(IPUtils.getIpAddr(request));
        }
        catch (Exception e) {
            sysLog.setIp("127.0.0.1");
        }
        if (user == null) {
            try {
                user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (user != null) {
            sysLog.setUserid(user.getUsername());
            sysLog.setUsername(user.getRealname());
        }
        sysLog.setCreateTime(new Date());
        this.baseCommonMapper.saveLog(sysLog);
    }

    @Override
    public void addLog(String logContent, Integer logType, Integer operateType) {
        this.addLog(logContent, logType, operateType, null);
    }
}

