/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.constant;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component(value="pca")
public class ProvinceCityArea {
    @Value(value="classpath:static/pca.json")
    private Resource jsonData;
    List<Area> areaList;

    public String getText(String code) {
        this.initAreaList();
        if (this.areaList != null || this.areaList.size() > 0) {
            ArrayList<String> ls = new ArrayList<String>();
            this.getAreaByCode(code, ls);
            return String.join((CharSequence)"/", ls);
        }
        return "";
    }

    public String getCode(String text) {
        this.initAreaList();
        if (this.areaList != null || this.areaList.size() > 0) {
            for (int i = this.areaList.size() - 1; i >= 0; --i) {
                if (text.indexOf(this.areaList.get(i).getText()) < 0) continue;
                return this.areaList.get(i).getId();
            }
        }
        return null;
    }

    public void getAreaByCode(String code, List<String> ls) {
        for (Area area : this.areaList) {
            if (!area.getId().equals(code)) continue;
            String pid = area.getPid();
            ls.add(0, area.getText());
            this.getAreaByCode(pid, ls);
        }
    }

    private void initAreaList() {
        if (this.areaList == null || this.areaList.size() == 0) {
            this.areaList = new ArrayList<Area>();
            try {
                File file = this.jsonData.getFile();
                String jsonData = this.jsonRead(file);
                JSONObject baseJson = JSONObject.parseObject((String)jsonData);
                JSONObject provinceJson = baseJson.getJSONObject("86");
                for (String provinceKey : provinceJson.keySet()) {
                    Area province = new Area(provinceKey, provinceJson.getString(provinceKey), "86");
                    this.areaList.add(province);
                    JSONObject cityJson = baseJson.getJSONObject(provinceKey);
                    for (String cityKey : cityJson.keySet()) {
                        Area city = new Area(cityKey, cityJson.getString(cityKey), provinceKey);
                        this.areaList.add(city);
                        JSONObject areaJson = baseJson.getJSONObject(cityKey);
                        if (areaJson == null) continue;
                        for (String areaKey : areaJson.keySet()) {
                            Area area = new Area(areaKey, areaJson.getString(areaKey), cityKey);
                            this.areaList.add(area);
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String jsonRead(File file) {
        StringBuilder buffer = new StringBuilder();
        try (Scanner scanner = null;){
            scanner = new Scanner(file, "utf-8");
            while (scanner.hasNextLine()) {
                buffer.append(scanner.nextLine());
            }
        }
        return buffer.toString();
    }

    class Area {
        String id;
        String text;
        String pid;

        public Area(String id, String text, String pid) {
            this.id = id;
            this.text = text;
            this.pid = pid;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public String getPid() {
            return this.pid;
        }
    }
}

