package com.mxchip.mx_log_dingtalk.info

import android.content.Context
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Build

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/26
 * @time: 2:39 PM
 * @desc:
 */


/**
 * 获取app版本信息和手机固件信息
 */
fun collectDeviceInfo(context: Context): StringBuffer {
    val mDeviceInfos: MutableMap<String, String> = LinkedHashMap()

    try {
        val pm: PackageManager = context.packageManager
        val pi: PackageInfo = pm.getPackageInfo(context.packageName, PackageManager.GET_ACTIVITIES)
        if (pi != null) {
            val versionName = if (pi.versionName == null) "null" else pi.versionName
            val versionCode = pi.versionCode.toString() + ""
            mDeviceInfos["versionName"] = versionName
            mDeviceInfos["versionCode"] = versionCode
        }
    } catch (e: PackageManager.NameNotFoundException) {

    }
    val fields = Build::class.java.declaredFields
    for (field in fields) {
        try {
            field.isAccessible = true
            mDeviceInfos[field.name] = field[null].toString()
        } catch (e: Exception) {

        }
    }
    mDeviceInfos["ANDROID_SDK_INT"] = Build.VERSION.SDK_INT.toString()
    mDeviceInfos["ANDROID_RELEASE"] = Build.VERSION.RELEASE
    val sb = StringBuffer()
    for ((key, value) in mDeviceInfos) {
        sb.append(key).append("=").append(value).append("\n")
    }
    return sb
}