package com.mxchip.mx_log_dingtalk.dingtalk

import android.util.Log
import okhttp3.*
import okhttp3.MediaType.Companion.toMediaType
import okhttp3.RequestBody.Companion.toRequestBody
import okhttp3.logging.HttpLoggingInterceptor
import java.io.IOException

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/26
 * @time: 4:04 PM
 * @desc:
 */
object DingTalkReport {

    private val TAG = "MXCHIP.DingTalkManager"

    private val JSON = "application/json; charset=utf-8".toMediaType()
    private const val preHttp = "https://oapi.dingtalk.com/robot/send?access_token="

    private val okHttpClient by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) {
        OkHttpClient.Builder()
                .addInterceptor(HttpLoggingInterceptor().apply {
                    level = HttpLoggingInterceptor.Level.BODY
                })
                .build()
    }

    /**
     * 调用webhook服务
     */
    fun report(info: String, stopService: () -> Unit) {
        val http = preHttp + DingTalkManager.getToken()
        Log.i(TAG, http)
        val body = "{\"msgtype\": \"text\", \n" +
                " \"text\": {\n" +
                "     \"content\": \"报警：${info}\"\n" +
                "  }\n" +
                "}"
        val requestBody = body.toRequestBody(JSON)
        val request = Request.Builder()
                .url(http)
                .post(requestBody)
                .build()
        okHttpClient.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                stopService.invoke()
            }

            override fun onResponse(call: Call, response: Response) {
                stopService.invoke()
            }
        })
    }
}