package com.mxchip.mx_log_dingtalk.dingtalk

import android.content.Context
import com.mxchip.mx_log_dingtalk.uncaughtHandler.DefaultCrashHandler
import com.mxchip.mx_log_dingtalk.uncaughtHandler.ICrashHandler

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/26
 * @time: 2:11 PM
 * @desc:
 */
object DingTalkManager {

    private val getDefaultCrashHandler = DefaultCrashHandler()

    private var DINGTALK_TOKEN = ""

    /**
     * webhook 自定义关键词
     */
    private var DINGTALK_KEYWORD = arrayOf<String>()

    fun getToken(): String {
        return DINGTALK_TOKEN
    }

    fun getKeyword(): Array<String> {
        return DINGTALK_KEYWORD
    }

    /**
     * token: webhook地址access_token字段的value
     * keyword：webhook中定义的关键字
     */
    fun init(context: Context, token: String, keyword: Array<String>) {
        init(context, token, keyword, getDefaultCrashHandler)
    }

    /**
     * token: webhook地址access_token字段的value
     * keyword：webhook中定义的关键字
     * handler：自定义UncaughtHandler处理类
     */
    fun init(context: Context, token: String, keyword: Array<String>, handler: ICrashHandler = getDefaultCrashHandler) {
        DINGTALK_TOKEN = token
        DINGTALK_KEYWORD = keyword
        handler.apply {
            init(context)
        }
    }
}