package com.mxchip.mx_log_dingtalk.uncaughtHandler

import android.content.Context

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/26
 * @time: 2:14 PM
 * @desc:
 */
interface ICrashHandler: Thread.UncaughtExceptionHandler {

    /**
     * 初始化，传入applicationcontext
     */
    fun init(context: Context, token: String, keyword: Array<String>)

    /**
     * 处理异常
     */
    fun dumpException(t: Thread?, e: Throwable?)

    /**
     * 系统defalutHandler执行退出功能
     */
    fun defaultExit(t: Thread?, e: Throwable?)

    override fun uncaughtException(t: Thread?, e: Throwable?) {
        dumpException(t, e)
        defaultExit(t, e)
    }
}