package com.mxchip.mx_log_dingtalk.dingtalk

import android.content.Context
import com.mxchip.mx_log_dingtalk.uncaughtHandler.DefaultCrashHandler
import com.mxchip.mx_log_dingtalk.uncaughtHandler.ICrashHandler

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/26
 * @time: 2:11 PM
 * @desc:
 */
object DingTalkManager {

    private val getDefaultCrashHandler = DefaultCrashHandler()

    /**
     * token: webhook地址access_token字段的value
     * keyword：webhook中定义的关键字
     */
    fun init(context: Context, token: String, keyword: Array<String>) {
        init(context, token, keyword, getDefaultCrashHandler)
    }

    /**
     * token: webhook地址access_token字段的value
     * keyword：webhook中定义的关键字
     * handler：自定义UncaughtHandler处理类
     */
    fun init(context: Context, token: String, keyword: Array<String>, handler: ICrashHandler = getDefaultCrashHandler) {
        handler.apply {
            init(context, token, keyword)
        }
    }
}