package com.mxchip.image_loader;

import android.content.Context;

import com.mxchip.interfaces.IImageLoader;

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/19
 * @time: 7:27 PM
 * @desc:
 */
public class ImageLoader {
    private static IImageLoader imageLoaderInstance = new ImageLoaderByEmpty();

    public static IImageLoader get() {
        return imageLoaderInstance;
    }

    public static void init(Context context, Class<? extends IImageLoader> clazz) {
        try {
            if (imageLoaderInstance != null) {
                imageLoaderInstance.release();
            }
            imageLoaderInstance = clazz.newInstance();
            imageLoaderInstance.init(context);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}
