package com.mxchip.config;

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/19
 * @time: 7:16 PM
 * @desc:
 */
public class InitConfig {

    /**
     * 默认文件缓存size
     * 单位：MB
     */
    static int defaultDiskCacheSize = 64;

    public static int getDefaultDiskCacheSize() {
        return defaultDiskCacheSize;
    }

    public static void setDefaultDiskCacheSize(int size) {
        defaultDiskCacheSize = size;
    }

    /**
     * 内存缓存大小
     * 单位：MB
     */
    int memoryCacheSize;

    /**
     * 文件缓存大小
     * 单位：MB
     */
    int diskCacheSize = defaultDiskCacheSize;

    /**
     * 网络加载线程池数量
     */
    int threadPoolSize;

    /**
     * 默认DisplayConfig
     */
    DisplayConfig displayConfig;

    public InitConfig memoryCacheSize(int size) {
        memoryCacheSize = size;
        return this;
    }

    public InitConfig diskCacheSize(int size) {
        diskCacheSize = size;
        return this;
    }

    public InitConfig threadPoolSize(int size) {
        threadPoolSize = size;
        return this;
    }

    public InitConfig displayConfig(DisplayConfig config) {
        displayConfig = config;
        return this;
    }

    public int getMemoryCacheSize() {
        return memoryCacheSize;
    }

    public int getDiskCacheSize() {
        return diskCacheSize;
    }

    public int getThreadPoolSize() {
        return threadPoolSize;
    }

    public DisplayConfig getDisplayConfig() {
        return displayConfig;
    }

}
