/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.mx_image_loader_engine_glide.transform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.security.MessageDigest;

public class GrayscaleTransformation
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;

    public GrayscaleTransformation(Context context) {
        this(Glide.get((Context)context).getBitmapPool());
    }

    public GrayscaleTransformation(BitmapPool pool) {
        this.mBitmapPool = pool;
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap.Config config;
        int height;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        Bitmap bitmap = this.mBitmapPool.get(width, height = source.getHeight(), config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        Canvas canvas = new Canvas(bitmap);
        ColorMatrix saturation = new ColorMatrix();
        saturation.setSaturation(0.0f);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(saturation));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(this.getId().getBytes());
    }

    private String getId() {
        return "GrayscaleTransformation()";
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

