/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.mx_image_loader_engine_glide.transform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.mxchip.mx_image_loader_engine_glide.transform.FastBlur;
import java.security.MessageDigest;

public class BlurTransformation
implements Transformation<Bitmap> {
    private static final int MAX_RADIUS = 25;
    private static final int DEFAULT_DOWN_SAMPLING = 1;
    private BitmapPool mBitmapPool;
    private int mRadius;
    private int mSample;

    public BlurTransformation(Context context) {
        this(context, 25);
    }

    public BlurTransformation(Context context, BitmapPool bitmapPool) {
        this(context, bitmapPool, 25);
    }

    public BlurTransformation(Context context, BitmapPool bitmapPool, int radius) {
        this(context, bitmapPool, radius, 1);
    }

    public BlurTransformation(Context context, int radius) {
        this(context, Glide.get((Context)context).getBitmapPool(), radius);
    }

    public BlurTransformation(Context context, int radius, int sample) {
        this(context, Glide.get((Context)context).getBitmapPool(), radius, sample);
    }

    public BlurTransformation(Context context, BitmapPool pool, int radius, int sample) {
        this.mBitmapPool = pool;
        this.mRadius = radius;
        this.mSample = sample;
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        Bitmap.Config config;
        int height;
        int scaleHeight;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        int scaleWidth = width / this.mSample;
        Bitmap bitmap = this.mBitmapPool.get(scaleWidth, scaleHeight = (height = source.getHeight()) / this.mSample, config = source.getConfig() != null ? source.getConfig() : Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)scaleWidth, (int)scaleHeight, (Bitmap.Config)config);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mSample, 1.0f / (float)this.mSample);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
        messageDigest.update(this.getId().getBytes());
    }

    private String getId() {
        return "BlurTransformation(radius=" + this.mRadius + ", sample=" + this.mSample + ")";
    }

    public void transformToView(Bitmap source, View sourceView, View targetView) {
        float translateY;
        float translateX;
        int scaledWidth;
        int scaledHeight;
        if (sourceView != null) {
            float dx = (float)source.getWidth() / (float)sourceView.getMeasuredWidth() / (float)this.mSample;
            float dy = (float)source.getHeight() / (float)sourceView.getMeasuredHeight() / (float)this.mSample;
            scaledHeight = (int)((float)targetView.getMeasuredHeight() * dy);
            scaledWidth = (int)((float)targetView.getMeasuredWidth() * dx);
            translateX = (float)(-targetView.getLeft()) * dx;
            translateY = (float)(-targetView.getTop()) * dy;
        } else {
            scaledWidth = targetView.getWidth() / this.mSample;
            scaledHeight = targetView.getHeight() / this.mSample;
            translateX = -targetView.getLeft() / this.mSample;
            translateY = -targetView.getTop() / this.mSample;
        }
        if (scaledHeight == 0 || scaledWidth == 0) {
            Log.d((String)"blurtest", (String)"size==0");
            return;
        }
        Bitmap bitmap = this.mBitmapPool.get(scaledWidth, scaledHeight, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate(translateX, translateY);
        canvas.scale(1.0f / (float)this.mSample, 1.0f / (float)this.mSample);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        targetView.setBackground((Drawable)new BitmapDrawable(targetView.getResources(), bitmap));
        targetView.invalidate();
    }
}

