/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.mx_image_loader_engine_glide.factory;

import android.content.Context;
import android.graphics.Bitmap;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CenterInside;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.FitCenter;
import com.bumptech.glide.request.RequestOptions;
import com.mxchip.config.DisplayConfig;
import com.mxchip.config.ScaleTypeConfig;
import com.mxchip.factory.DisplayConfigFactory;
import com.mxchip.mx_image_loader_engine_glide.transform.BlurTransformation;
import com.mxchip.mx_image_loader_engine_glide.transform.GrayscaleTransformation;
import com.mxchip.mx_image_loader_engine_glide.transform.RoundedCornersTransformation;
import java.util.ArrayList;
import java.util.List;

public class RequestOptionFactory
extends DisplayConfigFactory<RequestOptions> {
    private Context mContext;
    private List<Integer> mDirectionsCache;

    public RequestOptionFactory(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public RequestOptions toTargetConfig(DisplayConfig config) {
        RequestOptions options = new RequestOptions();
        if (config.getBitmapConfig() == Bitmap.Config.ARGB_8888) {
            options.format(DecodeFormat.PREFER_ARGB_8888);
        } else {
            options.format(DecodeFormat.PREFER_RGB_565);
        }
        if (config.getResizeWidth() != 0 && config.getResizeHeight() != 0) {
            options.override(config.getResizeWidth(), config.getResizeHeight());
        }
        if (config.isCacheOnDisc()) {
            if (config.isGif()) {
                options.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
            } else {
                options.diskCacheStrategy(DiskCacheStrategy.DATA);
                options.dontAnimate();
            }
        } else {
            options.diskCacheStrategy(DiskCacheStrategy.NONE);
        }
        options.skipMemoryCache(!config.isCacheInMemory());
        if (config.getLoadingImageResId() != -1) {
            options.placeholder(config.getLoadingImageResId());
        } else if (config.getLoadingImageDrawable() != null) {
            options.placeholder(config.getLoadingImageDrawable());
        }
        if (config.getLoadErrorImageResId() != -1) {
            options.error(config.getLoadErrorImageResId());
        } else if (config.getLoadErrorImage() != null) {
            options.error(config.getLoadErrorImage());
        }
        ArrayList<Object> transformationList = new ArrayList<Object>();
        if (this.mContext != null) {
            if ((config.getEffect() & 8) != 0) {
                options.format(DecodeFormat.PREFER_ARGB_8888);
                if (config.getEffectOutputView() == null) {
                    transformationList.add(new BlurTransformation(this.mContext, Glide.get((Context)this.mContext).getBitmapPool(), config.getBlurRadius(), config.getBlurSample()));
                }
            }
            if ((config.getEffect() & 1) != 0) {
                transformationList.add(new GrayscaleTransformation(this.mContext));
            }
        }
        if (config.getScaleType() != ScaleTypeConfig.None) {
            if (config.getScaleType() == ScaleTypeConfig.FitCenter) {
                transformationList.add(new FitCenter());
            } else if (config.getScaleType() == ScaleTypeConfig.CircleCrop) {
                transformationList.add(new CircleCrop());
            } else if (config.getScaleType() == ScaleTypeConfig.CenterInside) {
                transformationList.add(new CenterInside());
            } else {
                transformationList.add(new CenterCrop());
            }
        }
        try {
            if (config.getRadius() != 0 && this.mContext != null) {
                transformationList.add(new RoundedCornersTransformation(this.mContext, config.getRadius(), 0, config.getBackgroundColor(), this.getGlideCornerType(config), config.getBitmapConfig()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (transformationList.size() > 0) {
            MultiTransformation multiTransformation = new MultiTransformation(transformationList);
            options.transform((Transformation)multiTransformation);
        }
        return options;
    }

    private RoundedCornersTransformation.CornerType getGlideCornerType(DisplayConfig config) {
        if (this.mDirectionsCache == null) {
            this.mDirectionsCache = new ArrayList<Integer>();
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.ALL.ordinal(), 4369);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.TOP_LEFT.ordinal(), 4096);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.TOP_RIGHT.ordinal(), 256);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.BOTTOM_LEFT.ordinal(), 1);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.BOTTOM_RIGHT.ordinal(), 16);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.TOP.ordinal(), 4352);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.BOTTOM.ordinal(), 17);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.LEFT.ordinal(), 4097);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.RIGHT.ordinal(), 272);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_TOP_LEFT.ordinal(), 273);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_TOP_RIGHT.ordinal(), 4113);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_BOTTOM_LEFT.ordinal(), 4368);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_BOTTOM_RIGHT.ordinal(), 4353);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.DIAGONAL_FROM_TOP_LEFT.ordinal(), 4112);
            this.mDirectionsCache.add(RoundedCornersTransformation.CornerType.DIAGONAL_FROM_TOP_RIGHT.ordinal(), 257);
        }
        return RoundedCornersTransformation.CornerType.values()[this.mDirectionsCache.indexOf(config.getRadiusDirection())];
    }
}

