package com.mxchip.mx_image_loader_engine_glide.module;

import android.content.Context;

import androidx.annotation.NonNull;

import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.load.engine.cache.ExternalPreferredCacheDiskCacheFactory;
import com.bumptech.glide.module.AppGlideModule;
import com.mxchip.config.InitConfig;

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/19
 * @time: 7:53 PM
 * @desc:
 */
@GlideModule
public class MXAppGlideModule extends AppGlideModule {

    @Override
    public boolean isManifestParsingEnabled() {
        return false;
    }

    @Override
    public void applyOptions(@NonNull Context context, @NonNull GlideBuilder builder) {
//        MemorySizeCalculator calculator = new MemorySizeCalculator.Builder(context)
//                .setMemoryCacheScreens(4)
//                .setBitmapPoolScreens(4)
//                .build();
//        builder.setMemoryCache(new LruResourceCache(calculator.getMemoryCacheSize()));

        long diskSize = 1024 * 1024 * InitConfig.getDefaultDiskCacheSize();
        builder.setDiskCache(new ExternalPreferredCacheDiskCacheFactory(context, diskSize));
    }
}
