package com.mxchip.mx_image_loader_engine_glide.factory;

import android.content.Context;
import android.graphics.Bitmap;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CenterInside;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.FitCenter;
import com.bumptech.glide.request.RequestOptions;
import com.mxchip.config.DisplayConfig;
import com.mxchip.config.RadiusConfig;
import com.mxchip.config.ScaleTypeConfig;
import com.mxchip.config.SpecialEffectConfig;
import com.mxchip.factory.DisplayConfigFactory;
import com.mxchip.mx_image_loader_engine_glide.transform.BlurTransformation;
import com.mxchip.mx_image_loader_engine_glide.transform.GrayscaleTransformation;
import com.mxchip.mx_image_loader_engine_glide.transform.RoundedCornersTransformation;

import java.util.ArrayList;
import java.util.List;

/**
 * Created with Android Studio
 *
 * @author: chenxukun
 * @date: 2020/8/20
 * @time: 3:18 PM
 * @desc:
 */
public class RequestOptionFactory extends DisplayConfigFactory<RequestOptions> {

    private Context mContext;
    private List<Integer> mDirectionsCache;

    public RequestOptionFactory(Context context) {
        mContext = context.getApplicationContext();
    }

    @Override
    public RequestOptions toTargetConfig(DisplayConfig config) {
        RequestOptions options = new RequestOptions();

        if (config.getBitmapConfig() == Bitmap.Config.ARGB_8888) {
            options.format(DecodeFormat.PREFER_ARGB_8888);
        } else {
            options.format(DecodeFormat.PREFER_RGB_565);
        }

        if (config.getResizeWidth() != 0 && config.getResizeHeight() != 0) {
            options.override(config.getResizeWidth(), config.getResizeHeight());
        }

        if (config.isCacheOnDisc()) {
            if (config.isGif()) {
                options.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
            } else {
                options.diskCacheStrategy(DiskCacheStrategy.DATA);
                options.dontAnimate();
            }
        } else {
            options.diskCacheStrategy(DiskCacheStrategy.NONE);
        }

        options.skipMemoryCache(!config.isCacheInMemory());

        if (config.getLoadingImageResId() != -1) {
            options.placeholder(config.getLoadingImageResId());
        } else if (config.getLoadingImageDrawable() != null) {
            options.placeholder(config.getLoadingImageDrawable());
        }
        if (config.getLoadErrorImageResId() != -1) {
            options.error(config.getLoadErrorImageResId());
        } else if (config.getLoadErrorImage() != null) {
            options.error(config.getLoadErrorImage());
        }

        List<Transformation> transformationList = new ArrayList<Transformation>();
        if (mContext != null) {
            if ((config.getEffect() & SpecialEffectConfig.Blur) != 0) {
                options.format(DecodeFormat.PREFER_ARGB_8888);
                if (config.getEffectOutputView() == null) {
                    transformationList.add(new BlurTransformation(mContext, Glide.get(mContext).getBitmapPool(), config.getBlurRadius(), config.getBlurSample()));
                }
            }
            if ((config.getEffect() & SpecialEffectConfig.GrayScale) != 0) {
                transformationList.add(new GrayscaleTransformation(mContext));
            }
        }

        if (config.getScaleType() == ScaleTypeConfig.None) {

        } else if (config.getScaleType() == ScaleTypeConfig.FitCenter) {
            transformationList.add(new FitCenter());
        } else if (config.getScaleType() == ScaleTypeConfig.CircleCrop) {
            transformationList.add(new CircleCrop());
        } else if (config.getScaleType() == ScaleTypeConfig.CenterInside) {
            transformationList.add(new CenterInside());
        } else {
            transformationList.add(new CenterCrop());
        }

        try {
            if (config.getRadius() != 0 && mContext != null) {
                transformationList.add(new RoundedCornersTransformation(mContext, config.getRadius(), 0, config.getBackgroundColor(), getGlideCornerType(config), config.getBitmapConfig()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (transformationList.size() > 0) {
            MultiTransformation multiTransformation = new MultiTransformation(transformationList);
            options.transform(multiTransformation);
        }

        return options;
    }

    private RoundedCornersTransformation.CornerType getGlideCornerType(DisplayConfig config) {
        if (mDirectionsCache == null) {
            mDirectionsCache = new ArrayList<>();
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.ALL.ordinal(), RadiusConfig.RadiusAll);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.TOP_LEFT.ordinal(), RadiusConfig.RadiusTopLeft);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.TOP_RIGHT.ordinal(), RadiusConfig.RadiusTopRight);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.BOTTOM_LEFT.ordinal(), RadiusConfig.RadiusBottomLeft);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.BOTTOM_RIGHT.ordinal(), RadiusConfig.RadiusBottomRight);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.TOP.ordinal(), RadiusConfig.RadiusTop);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.BOTTOM.ordinal(), RadiusConfig.RadiusBottom);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.LEFT.ordinal(), RadiusConfig.RadiusLeft);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.RIGHT.ordinal(), RadiusConfig.RadiusRight);

            mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_TOP_LEFT.ordinal(), RadiusConfig.RadiusOtherTopLeft);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_TOP_RIGHT.ordinal(), RadiusConfig.RadiusOtherTopRight);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_BOTTOM_LEFT.ordinal(), RadiusConfig.RadiusOtherBottomLeft);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.OTHER_BOTTOM_RIGHT.ordinal(), RadiusConfig.RadiusOtherBottomRight);

            mDirectionsCache.add(RoundedCornersTransformation.CornerType.DIAGONAL_FROM_TOP_LEFT.ordinal(), RadiusConfig.RadiusDiagonalFromTopLeft);
            mDirectionsCache.add(RoundedCornersTransformation.CornerType.DIAGONAL_FROM_TOP_RIGHT.ordinal(), RadiusConfig.RadiusDiagonalFromTopRight);
        }
        return RoundedCornersTransformation.CornerType.values()[mDirectionsCache.indexOf(config.getRadiusDirection())];
    }
}
