/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugins.coverage.core;

import org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation;
import org.mule.runtime.api.component.location.ComponentLocation;

import static org.mule.munit.plugins.coverage.core.model.CoverageComponentLocation.fromComponentLocation;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;



/**
 * It just store locations when the interceptor ask it to do so
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class LocationAccumulator {

  protected Set<ComponentLocation> coveredLocations = new HashSet<>();

  /**
   * Register the execution of a processor
   * 
   * @param location
   */
  public void addCoveredLocation(ComponentLocation location) {
    coveredLocations.add(location);
  }

  public Set<ComponentLocation> getLocations() {
    return new HashSet<>(coveredLocations);
  }

  public Set<CoverageComponentLocation> getCoverageLocations() {
    return coveredLocations.stream().map(CoverageComponentLocation::fromComponentLocation).collect(Collectors.toSet());
  }

  public Set<ComponentLocation> getCoveredLocations() {
    return coveredLocations;
  }

}
