/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.jvm;

import com.vdurmont.semver4j.Semver;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.mule.runtime.module.embedded.internal.jvm.JvmVersionInterval;

public class JvmVersionIntervalUnion {
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(\\[[^\\)]*\\))");
    private final List<JvmVersionInterval> intervals;

    public static JvmVersionIntervalUnion parse(String intervalUnionString) {
        Matcher intervalUnionMatcher = INTERVAL_PATTERN.matcher(intervalUnionString);
        ArrayList<JvmVersionInterval> intervals = new ArrayList<JvmVersionInterval>();
        while (intervalUnionMatcher.find()) {
            intervals.add(JvmVersionInterval.parse(intervalUnionMatcher.group()));
        }
        return new JvmVersionIntervalUnion(intervals);
    }

    public JvmVersionIntervalUnion(List<JvmVersionInterval> intervals) {
        this.intervals = intervals;
    }

    public boolean includes(String versionString) {
        return this.includes(new Semver(JvmVersionInterval.normalizeJava8OrLowerVersion(versionString), Semver.SemverType.LOOSE).toStrict());
    }

    private boolean includes(Semver version) {
        return this.intervals.stream().anyMatch(interval -> interval.includes(version));
    }

    public String toString() {
        return this.intervals.stream().map(JvmVersionInterval::toString).collect(Collectors.joining(",", "", ""));
    }
}

