/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.munit.common.protocol.message.TestStatus;
import org.mule.munit.runner.model.TestResult;

public class SuiteResult {
    private String name;
    private long elapsedTime;
    private List<TestResult> results = new ArrayList<TestResult>();

    public SuiteResult(String name) {
        this.name = name;
    }

    public boolean hasSucceeded() {
        return this.results.stream().allMatch(r -> r.getStatus() == TestStatus.SUCCESS);
    }

    public int getNumberOfFailures() {
        return (int)this.results.stream().filter(r -> r.getStatus() == TestStatus.FAILURE).count();
    }

    public int getNumberOfErrors() {
        return this.getErrorTests().size();
    }

    public int getNumberOfSkipped() {
        return (int)this.results.stream().filter(r -> r.getStatus() == TestStatus.IGNORED).count();
    }

    public int getNumberOfTests() {
        return this.results.size();
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public String getTestName() {
        return this.name;
    }

    public List<TestResult> getFailingTests() {
        return this.results.stream().filter(r -> r.getStatus() == TestStatus.FAILURE).collect(Collectors.toList());
    }

    public List<TestResult> getErrorTests() {
        return this.results.stream().filter(r -> r.getStatus() == TestStatus.ERROR).collect(Collectors.toList());
    }

    public void add(TestResult result) {
        this.results.add(result);
    }
}

