/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.munit.runner.component.TestComponent;
import org.mule.munit.runner.component.TestComponentInfoProvider;
import org.mule.munit.runner.flow.AfterSuite;
import org.mule.munit.runner.flow.AfterTest;
import org.mule.munit.runner.flow.BeforeSuite;
import org.mule.munit.runner.flow.BeforeTest;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.config.api.LazyComponentInitializer;

public class TestComponentLocator {
    public static final String CONFIG_IDENTIFIER = "munit:config";
    public static final String BEFORE_SUITE_IDENTIFIER = "munit:before-suite";
    public static final String AFTER_SUITE_IDENTIFIER = "munit:after-suite";
    public static final String BEFORE_TEST_IDENTIFIER = "munit:before-test";
    public static final String AFTER_TEST_IDENTIFIER = "munit:after-test";
    public static final String TEST_IDENTIFIER = "munit:test";
    private final ConfigurationComponentLocator configurationComponentLocator;
    private final LazyComponentInitializer lazyComponentInitializer;
    private final List<ComponentIdentifier> testComponentIdentifiers = new ArrayList<ComponentIdentifier>();
    private final Set<String> testNamespaces = new HashSet<String>();

    public TestComponentLocator(ConfigurationComponentLocator configurationComponentLocator, LazyComponentInitializer lazyComponentInitializer, Collection<TestComponentInfoProvider> testComponentInfoProviders) {
        this.configurationComponentLocator = configurationComponentLocator;
        this.lazyComponentInitializer = lazyComponentInitializer;
        testComponentInfoProviders.forEach(testComponentInfoProvider -> {
            ComponentIdentifier testComponentIdentifier = testComponentInfoProvider.getComponentIdentifier();
            this.testComponentIdentifiers.add(testComponentIdentifier);
            this.testNamespaces.add(testComponentIdentifier.getNamespace());
        });
    }

    public void initializeComponents(String suitePath) {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> this.belongsToSuite(suitePath, componentLocation) != false && this.isTestNamespace(componentLocation));
    }

    private boolean isTestNamespace(ComponentLocation componentLocation) {
        return this.testNamespaces.contains(componentLocation.getComponentIdentifier().getIdentifier().getNamespace());
    }

    private Boolean belongsToSuite(String suitePath, ComponentLocation componentLocation) {
        return componentLocation.getFileName().map(suitePath::equals).orElse(false);
    }

    public Optional<MunitModule> lookupMunitModule() {
        ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)CONFIG_IDENTIFIER);
        List components = this.configurationComponentLocator.find(componentIdentifier);
        if (!components.isEmpty()) {
            return Optional.of((MunitModule)((Object)components.get(0)));
        }
        return Optional.empty();
    }

    public Optional<BeforeSuite> lookupBeforeSuite() {
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)BEFORE_SUITE_IDENTIFIER));
        if (!components.isEmpty()) {
            return Optional.of((BeforeSuite)((Object)components.get(0)));
        }
        return Optional.empty();
    }

    public Optional<AfterSuite> lookupAfterSuite() {
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)AFTER_SUITE_IDENTIFIER));
        if (!components.isEmpty()) {
            return Optional.of((AfterSuite)((Object)components.get(0)));
        }
        return Optional.empty();
    }

    public Optional<BeforeTest> lookupBeforeTest() {
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)BEFORE_TEST_IDENTIFIER));
        if (!components.isEmpty()) {
            return Optional.of((BeforeTest)((Object)components.get(0)));
        }
        return Optional.empty();
    }

    public Optional<AfterTest> lookupAfterTest() {
        List components = this.configurationComponentLocator.find(ComponentIdentifier.buildFromStringRepresentation((String)AFTER_TEST_IDENTIFIER));
        if (!components.isEmpty()) {
            return Optional.of((AfterTest)((Object)components.get(0)));
        }
        return Optional.empty();
    }

    public Collection<TestComponent> lookupTests() {
        return this.testComponentIdentifiers.stream().map(testIdentifier -> this.configurationComponentLocator.find(testIdentifier)).flatMap(Collection::stream).filter(testComponent -> testComponent instanceof TestComponent).map(testComponent -> (TestComponent)testComponent).collect(Collectors.toList());
    }
}

