/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.model.builders;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.runner.component.TestComponent;

public class TestRunFilter {
    public static final String NO_TAG_TOKEN = "NO_TAG";

    public boolean shouldRunTest(String testName, Set<String> testTags, List<RunConfiguration.Test> testNameList, Set<String> tags, String suitePath) {
        return this.isTestInList(testName, testNameList, suitePath) && this.isTagInTest(testTags, tags);
    }

    public boolean shouldRunTest(String testName, List<RunConfiguration.Test> testNameList, String suitePath) {
        return this.isTestInList(testName, testNameList, suitePath);
    }

    public boolean shouldRunTest(TestComponent testComponent, List<RunConfiguration.Test> testNameList, Set<String> tags, String suitePath) {
        return this.isTestInList(testComponent.getName(), testNameList, suitePath) && this.isTagInTest(testComponent.getTags(), tags);
    }

    private boolean isTestInList(String testName, List<RunConfiguration.Test> testNameList, String suitePath) {
        if (null == testNameList || testNameList.isEmpty()) {
            return true;
        }
        return testNameList.stream().anyMatch(map -> map.getSuite().equals(suitePath) && map.getName().equals(testName));
    }

    private boolean isTagInTest(Set<String> testTags, Set<String> tags) {
        return tags == null || tags.isEmpty() || this.shouldRunWithNoTag(testTags, tags) || this.tagsInCommon(testTags, tags);
    }

    private boolean tagsInCommon(Set<String> testTags, Set<String> userTags) {
        return !Collections.disjoint(this.toLowerCaseAndTrim(testTags), this.toLowerCaseAndTrim(userTags));
    }

    private Set<String> toLowerCaseAndTrim(Set<String> tags) {
        return tags.stream().map(StringUtils::lowerCase).map(String::trim).collect(Collectors.toSet());
    }

    private boolean shouldRunWithNoTag(Set<String> testTags, Set<String> tags) {
        return testTags.isEmpty() && tags.stream().anyMatch(tag -> tag.trim().equalsIgnoreCase(NO_TAG_TOKEN));
    }
}

