/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.rules;

import java.util.Collections;
import java.util.Set;
import org.mule.munit.common.util.Preconditions;

public class TestDescription {
    private final String name;
    private final String description;
    private final boolean ignored;
    private final Set<String> tags;

    private TestDescription(String name, String description, boolean ignored, Set<String> tags) {
        this.name = name;
        this.description = description;
        this.ignored = ignored;
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description = "";
        private boolean ignored;
        private Set<String> tags = Collections.emptySet();

        private Builder() {
        }

        public Builder name(String name) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Name cannot be null");
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            Preconditions.checkArgument((description != null ? 1 : 0) != 0, (String)"Description cannot be null");
            this.description = description;
            return this;
        }

        public Builder ignored(boolean ignored) {
            this.ignored = ignored;
            return this;
        }

        public Builder tags(Set<String> tags) {
            Preconditions.checkArgument((tags != null ? 1 : 0) != 0, (String)"Tags cannot be null");
            this.tags = tags;
            return this;
        }

        public TestDescription build() {
            return new TestDescription(this.name, this.description, this.ignored, this.tags);
        }
    }
}

