/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.functions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;

public class OsEqualToFunction
implements ExpressionFunction {
    private final ConfigurationProperties configurationProperties;

    public OsEqualToFunction(ConfigurationProperties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Object call(Object[] parameters, BindingContext bindingContext) {
        String osName = (String)parameters[0];
        return this.getCurrentOsName().equals(osName);
    }

    public Optional<DataType> returnType() {
        return Optional.of(DataType.BOOLEAN);
    }

    public List<FunctionParameter> parameters() {
        return Collections.singletonList(new FunctionParameter("osName", DataType.STRING));
    }

    private String getCurrentOsName() {
        return (String)this.configurationProperties.resolveStringProperty("os.name").orElseThrow(() -> new IllegalStateException("Unable to check operating system: 'os.name' property is not defined"));
    }
}

