/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.properties;

import java.util.Objects;
import java.util.Optional;
import org.mule.munit.common.util.FreePortFinder;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;

public class DynamicPortPropertiesProvider
implements ConfigurationPropertiesProvider {
    private static final Integer DEFAULT_MIN_PORT = 1;
    private static final Integer DEFAULT_MAX_PORT = 65535;
    private String propertyName;
    private DynamicPortConfigurationProperty configurationProperty;

    public DynamicPortPropertiesProvider(String propertyName, Integer min, Integer max) {
        this.propertyName = propertyName;
        this.configurationProperty = new DynamicPortConfigurationProperty(this, propertyName, this.findPort(min, max));
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        return Objects.equals(this.propertyName, configurationAttributeKey) ? Optional.of(this.configurationProperty) : Optional.empty();
    }

    public String getDescription() {
        return String.format("<munit:dynamic-port propertyName=\"%s\" >", this.propertyName);
    }

    private Integer findPort(Integer min, Integer max) {
        Integer minPort = Optional.ofNullable(min).orElse(DEFAULT_MIN_PORT);
        Integer maxPort = Optional.ofNullable(max).orElse(DEFAULT_MAX_PORT);
        if (minPort > maxPort) {
            throw new IllegalArgumentException(String.format("Minimum port %d cannot be bigger than maximum port %d", minPort, maxPort));
        }
        return new FreePortFinder(minPort.intValue(), maxPort.intValue()).find();
    }

    private static class DynamicPortConfigurationProperty
    implements ConfigurationProperty {
        private Object source;
        private String propertyName;
        private Integer port;

        DynamicPortConfigurationProperty(Object source, String propertyName, Integer port) {
            this.source = source;
            this.propertyName = propertyName;
            this.port = port;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getRawValue() {
            return String.valueOf(this.port);
        }

        public String getKey() {
            return this.propertyName;
        }
    }
}

