/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.factory;

import java.util.List;
import javax.inject.Inject;
import org.mule.munit.runner.flow.TestFlow;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public class TestProcessorChainFactory
extends AbstractComponentFactory<MessageProcessorChain> {
    @Inject
    protected PrivilegedMuleContext muleContext;
    protected List processors;
    protected String name;

    public void setMessageProcessors(List processors) {
        this.processors = processors;
    }

    public MessageProcessorChain doGetObject() throws Exception {
        DefaultMessageProcessorChainBuilder builder = this.getBuilderInstance();
        for (Object processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain(new Processor[]{(Processor)processor});
                continue;
            }
            throw new IllegalArgumentException(String.format("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured. Found a %s", processor.getClass().getName()));
        }
        return DefaultMessageProcessorChainBuilder.newLazyProcessorChainBuilder((AbstractMessageProcessorChainBuilder)builder, (MuleContext)this.muleContext, () -> this.getProcessingStrategy(this.muleContext.getConfigurationComponentLocator(), this.getDefaultProcessingStrategyFactory(), this.getRootContainerLocation()));
    }

    protected DefaultMessageProcessorChainBuilder getBuilderInstance() {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("munit processor chain '" + this.name + "'");
        return builder;
    }

    public void setName(String name) {
        this.name = name;
    }

    private ProcessingStrategy getProcessingStrategy(ConfigurationComponentLocator locator, ProcessingStrategyFactory processingStrategyFactory, Location rootContainerLocation) {
        if (processingStrategyFactory == null) {
            return null;
        }
        TestFlow testFlow = TestProcessorChainFactory.findTest(locator, rootContainerLocation);
        ProcessingStrategy processingStrategy = processingStrategyFactory.create((MuleContext)this.muleContext, this.name);
        testFlow.addProcessingStrategy(this.name, processingStrategy);
        return processingStrategy;
    }

    private static TestFlow findTest(ConfigurationComponentLocator locator, Location rootContainerLocation) {
        return locator.find(rootContainerLocation).filter(loc -> loc instanceof TestFlow).map(testFlow -> (TestFlow)testFlow).orElseThrow(() -> new IllegalStateException("Chain was expected to belong to a test. Root container was: " + rootContainerLocation.getGlobalName()));
    }

    private ProcessingStrategyFactory getDefaultProcessingStrategyFactory() {
        return this.muleContext.getConfiguration().getDefaultProcessingStrategyFactory();
    }
}

