/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.properties;

import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.runner.component.properties.DynamicPortPropertiesProvider;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationPropertiesProviderFactory;

public class DynamicPortPropertiesProviderFactory
implements ConfigurationPropertiesProviderFactory {
    public static final String DYNAMIC_PORT_ELEMENT = "dynamic-port";
    public static final ComponentIdentifier DYNAMIC_PORT = ComponentIdentifier.builder().namespace("munit").name("dynamic-port").build();
    public static final String PROPERTY_NAME_PARAMETER = "propertyName";
    public static final String MIN_PORT_PARAMETER = "min";
    public static final String MAX_PORT_PARAMETER = "max";

    public ComponentIdentifier getSupportedComponentIdentifier() {
        return DYNAMIC_PORT;
    }

    public ConfigurationPropertiesProvider createProvider(ConfigurationParameters parameters, ResourceProvider externalResourceProvider) {
        String propertyName = parameters.getStringParameter(PROPERTY_NAME_PARAMETER);
        Integer min = this.getOptionalIntegerParameter(parameters, MIN_PORT_PARAMETER);
        Integer max = this.getOptionalIntegerParameter(parameters, MAX_PORT_PARAMETER);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)propertyName), (String)String.format("Required attribute '%s' of '%s' not found", PROPERTY_NAME_PARAMETER, DYNAMIC_PORT_ELEMENT));
        return new DynamicPortPropertiesProvider(propertyName, min, max);
    }

    private Integer getOptionalIntegerParameter(ConfigurationParameters parameters, String parameterName) {
        String value;
        try {
            value = parameters.getStringParameter(parameterName);
        }
        catch (Exception e) {
            return null;
        }
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Attribute '%s' must be a valid port number, but was '%s'", parameterName, value), e);
        }
    }
}

