/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.model;

import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import org.mule.munit.remote.coverage.model.CoverageTypedComponentIdentifierReport;
import org.mule.munit.remote.coverage.server.LocationPart;
import org.mule.munit.remote.coverage.server.TypedComponentIdentifier;

public class CoverageLocationPartReport
implements LocationPart,
Serializable {
    private static final long serialVersionUID = 5757545892752260058L;
    private String partPath;
    private String fileName;
    private Integer lineInFile;
    private CoverageTypedComponentIdentifierReport partIdentifier;

    public CoverageLocationPartReport(String partPath, Optional<CoverageTypedComponentIdentifierReport> partIdentifier, Optional<String> fileName, Optional<Integer> lineInFile) {
        this.partPath = partPath;
        this.partIdentifier = partIdentifier.orElse(null);
        fileName.ifPresent(configFileName -> {
            this.fileName = configFileName;
        });
        lineInFile.ifPresent(line -> {
            this.lineInFile = line;
        });
    }

    @Override
    public String getPartPath() {
        return this.partPath;
    }

    @Override
    public Optional<TypedComponentIdentifier> getPartIdentifier() {
        return Optional.ofNullable(this.partIdentifier);
    }

    @Override
    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    @Override
    public Optional<Integer> getLineInFile() {
        return Optional.ofNullable(this.lineInFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageLocationPartReport that = (CoverageLocationPartReport)o;
        if (!this.getPartPath().equals(that.getPartPath())) {
            return false;
        }
        if (this.getPartIdentifier() != null ? !this.getPartIdentifier().equals(that.getPartIdentifier()) : that.getPartIdentifier() != null) {
            return false;
        }
        if (this.getFileName() != null ? !this.getFileName().equals(that.getFileName()) : that.getFileName() != null) {
            return false;
        }
        return this.getLineInFile() != null ? this.getLineInFile().equals(that.getLineInFile()) : that.getLineInFile() == null;
    }

    public int hashCode() {
        int result = this.getPartPath().hashCode();
        result = 31 * result + (this.getPartIdentifier() != null ? this.getPartIdentifier().hashCode() : 0);
        result = 31 * result + (this.getFileName() != null ? this.getFileName().hashCode() : 0);
        result = 31 * result + (this.getLineInFile() != null ? this.getLineInFile().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CoverageLocationPart{partPath='" + this.partPath + '\'' + ", partIdentifier=" + this.partIdentifier + ", fileName='" + this.fileName + '\'' + ", lineInFile=" + this.lineInFile + '}';
    }

    @Override
    public Optional<Integer> getStartColumn() {
        return Optional.empty();
    }

    @Override
    public OptionalInt getLine() {
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt getColumn() {
        return OptionalInt.empty();
    }
}

