/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal.jvm;

import com.vdurmont.semver4j.Range;
import com.vdurmont.semver4j.Semver;

public class JvmVersionInterval {
    private final Range lowerRange;
    private final Range higherRange;

    public static JvmVersionInterval parse(String intervalString) {
        boolean higherOpen;
        boolean lowerOpen;
        String[] intervalEndpoints = intervalString.split(",");
        String lowerEndpoint = intervalEndpoints[0];
        String higherEndpoint = intervalEndpoints[1];
        if (lowerEndpoint.startsWith("(")) {
            lowerOpen = true;
        } else if (lowerEndpoint.startsWith("[")) {
            lowerOpen = false;
        } else {
            throw new IllegalArgumentException("Invalid open/closed notation ('" + lowerEndpoint.charAt(0) + "') for lower endpoint '" + lowerEndpoint + "'. '(' or '[' expected.");
        }
        if (higherEndpoint.endsWith(")")) {
            higherOpen = true;
        } else if (higherEndpoint.endsWith("]")) {
            higherOpen = false;
        } else {
            throw new IllegalArgumentException("Invalid open/closed notation ('" + higherEndpoint.charAt(higherEndpoint.length() - 1) + "') for higher endpoint '" + higherEndpoint + "'. '(' or '[' expected.");
        }
        return new JvmVersionInterval(lowerEndpoint.substring(1), lowerOpen, higherEndpoint.substring(0, higherEndpoint.length() - 1), higherOpen);
    }

    public JvmVersionInterval(String lowerEndpoint, boolean lowerOpen, String higherEndpoint, boolean higherOpen) {
        this.lowerRange = new Range(new Semver(JvmVersionInterval.normalizeJava8OrLowerVersion(lowerEndpoint), Semver.SemverType.LOOSE).toStrict(), lowerOpen ? Range.RangeOperator.GT : Range.RangeOperator.GTE);
        this.higherRange = new Range(new Semver(JvmVersionInterval.normalizeJava8OrLowerVersion(higherEndpoint), Semver.SemverType.LOOSE).toStrict(), higherOpen ? Range.RangeOperator.LT : Range.RangeOperator.LTE);
    }

    public boolean includes(Semver version) {
        return this.lowerRange.isSatisfiedBy(version) && this.higherRange.isSatisfiedBy(version);
    }

    public String toString() {
        return this.lowerRange.toString() + " && " + this.higherRange.toString();
    }

    static String normalizeJava8OrLowerVersion(String versionString) {
        if (versionString.startsWith("1.")) {
            return versionString.substring(2).replace("_", ".");
        }
        return versionString.replace("_", ".");
    }
}

