/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Optional;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.mule.maven.client.internal.GraphCycleAvoidingTransformer;

public abstract class ParentContextDependencyGraphTransformer
extends GraphCycleAvoidingTransformer {
    @Override
    protected void transformNode(DependencyNode node) {
        Optional<DependencyNode> parent = Optional.empty();
        if (this.isSelectableParent(node)) {
            parent = Optional.of(node);
        } else if (node.getData().containsKey(this.getAncestorKey())) {
            parent = Optional.of((DependencyNode)node.getData().get(this.getAncestorKey()));
        }
        for (DependencyNode child : node.getChildren()) {
            if (!this.isChildNode(child)) continue;
            this.markChildNode(child, parent);
        }
    }

    protected void markChildNode(DependencyNode childNode, Optional<DependencyNode> parent) {
        parent.ifPresent(parentNode -> {
            Artifact nodeArtifact = childNode.getArtifact();
            if (!childNode.getData().containsKey("nodeOriginalArtifact")) {
                childNode.setData("nodeOriginalArtifact", nodeArtifact);
                String newArtifactId = nodeArtifact.getArtifactId() + "<-" + ArtifactIdUtils.toId(parentNode.getArtifact());
                DefaultArtifact newNodeArtifact = new DefaultArtifact(nodeArtifact.getGroupId(), newArtifactId, nodeArtifact.getClassifier(), nodeArtifact.getExtension(), nodeArtifact.getVersion(), nodeArtifact.getProperties(), nodeArtifact.getFile());
                childNode.setArtifact(newNodeArtifact);
                childNode.setData(this.getAncestorKey(), parentNode);
            }
        });
    }

    protected abstract boolean isSelectableParent(DependencyNode var1);

    protected abstract boolean isChildNode(DependencyNode var1);

    protected abstract String getAncestorKey();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return null != obj && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

