/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.munit.common.util.Preconditions;

public class Throwables {
    public static List<Throwable> getCausalChain(Throwable throwable) {
        Throwable cause;
        Preconditions.checkNotNull(throwable);
        ArrayList<Throwable> causes = new ArrayList<Throwable>(4);
        causes.add(throwable);
        Throwable slowPointer = throwable;
        boolean advanceSlowPointer = false;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
            causes.add(throwable);
            if (throwable == slowPointer) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (advanceSlowPointer) {
                slowPointer = slowPointer.getCause();
            }
            advanceSlowPointer = !advanceSlowPointer;
        }
        return Collections.unmodifiableList(causes);
    }

    private Throwables() {
    }
}

