/*
 * Decompiled with CFR 0.152.
 */
package com.evanlennick.retry4j.config;

import com.evanlennick.retry4j.backoff.BackoffStrategy;
import com.evanlennick.retry4j.backoff.ExponentialBackoffStrategy;
import com.evanlennick.retry4j.backoff.FibonacciBackoffStrategy;
import com.evanlennick.retry4j.backoff.FixedBackoffStrategy;
import com.evanlennick.retry4j.backoff.NoWaitBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomBackoffStrategy;
import com.evanlennick.retry4j.backoff.RandomExponentialBackoffStrategy;
import com.evanlennick.retry4j.config.RetryConfig;
import com.evanlennick.retry4j.exception.InvalidRetryConfigException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class RetryConfigBuilder {
    public static final String MUST_SPECIFY_BACKOFF__ERROR_MSG = "Retry config must specify a backoff strategy!";
    public static final String MUST_SPECIFY_MAX_TRIES__ERROR_MSG = "Retry config must specify a maximum number of tries!";
    public static final String CAN_ONLY_SPECIFY_ONE_BACKOFF_STRAT__ERROR_MSG = "Retry config cannot specify more than one backoff strategy!";
    public static final String CAN_ONLY_SPECIFY_ONE_EXCEPTION_STRAT__ERROR_MSG = "Retry config cannot specify more than one exception strategy!";
    public static final String ALREADY_SPECIFIED_NUMBER_OF_TRIES__ERROR_MSG = "Number of tries can only be specified once!";
    public static final String CAN_ONLY_SPECIFY_CUSTOM_EXCEPTION_STRAT__ERROR_MSG = "You cannot use built in exception logic and custom exception logic in the same config!";
    public static final String MUST_SPECIFY_MAX_TRIES_ABOVE_0__ERROR_MSG = "Cannot specify a maximum number of tries less than 1!";
    public static final String SHOULD_SPECIFY_RETRY_COUNT_AS_POSITIVE__ERROR_MSG = "Max number of retries must be a non-negative number.";
    public static final String SHOULD_SPECIFY_DELAY_BETWEEN_RETRIES_AS_POSTIVE__ERROR_MSG = "Delay between retries must be a non-negative Duration.";
    private boolean builtInExceptionStrategySpecified = false;
    private boolean validationEnabled = true;
    private Boolean retryOnAnyException = false;
    private Set<Class<? extends Exception>> retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
    private Set<Class<? extends Exception>> retryOnAnyExceptionExcluding = new HashSet<Class<? extends Exception>>();
    private Integer maxNumberOfTries;
    private Duration delayBetweenRetries;
    private BackoffStrategy backoffStrategy;
    private Object valueToRetryOn;
    private Boolean retryOnValue = false;
    private Function<Exception, Boolean> customRetryOnLogic;
    private boolean retryOnCausedBy;

    public RetryConfigBuilder() {
    }

    public RetryConfigBuilder(boolean validationEnabled) {
        this();
        this.validationEnabled = validationEnabled;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public RetryConfigBuilder retryOnAnyException() {
        this.validateExceptionStrategyAddition();
        this.retryOnAnyException = true;
        this.builtInExceptionStrategySpecified = true;
        return this;
    }

    public RetryConfigBuilder failOnAnyException() {
        this.validateExceptionStrategyAddition();
        this.retryOnAnyException = false;
        this.retryOnSpecificExceptions = new HashSet<Class<? extends Exception>>();
        this.builtInExceptionStrategySpecified = true;
        return this;
    }

    public RetryConfigBuilder retryOnCausedBy() {
        this.retryOnCausedBy = true;
        return this;
    }

    @SafeVarargs
    public final RetryConfigBuilder retryOnSpecificExceptions(Class<? extends Exception> ... exceptions) {
        this.validateExceptionStrategyAddition();
        HashSet<Class<? extends Exception>> setOfExceptions = new HashSet<Class<? extends Exception>>(Arrays.asList(exceptions));
        this.retryOnSpecificExceptions = setOfExceptions;
        this.builtInExceptionStrategySpecified = true;
        return this;
    }

    @SafeVarargs
    public final RetryConfigBuilder retryOnAnyExceptionExcluding(Class<? extends Exception> ... exceptions) {
        this.validateExceptionStrategyAddition();
        HashSet<Class<? extends Exception>> setOfExceptions = new HashSet<Class<? extends Exception>>(Arrays.asList(exceptions));
        this.retryOnAnyExceptionExcluding = setOfExceptions;
        this.builtInExceptionStrategySpecified = true;
        return this;
    }

    public final RetryConfigBuilder retryOnReturnValue(Object value) {
        this.retryOnValue = true;
        this.valueToRetryOn = value;
        return this;
    }

    public RetryConfigBuilder retryOnCustomExceptionLogic(Function<Exception, Boolean> customRetryFunction) {
        this.customRetryOnLogic = customRetryFunction;
        return this;
    }

    public RetryConfigBuilder withMaxNumberOfTries(int max) {
        if (max < 1) {
            throw new InvalidRetryConfigException(MUST_SPECIFY_MAX_TRIES_ABOVE_0__ERROR_MSG);
        }
        if (this.maxNumberOfTries != null) {
            throw new InvalidRetryConfigException(ALREADY_SPECIFIED_NUMBER_OF_TRIES__ERROR_MSG);
        }
        if (max < 0) {
            throw new InvalidRetryConfigException(SHOULD_SPECIFY_RETRY_COUNT_AS_POSITIVE__ERROR_MSG);
        }
        this.maxNumberOfTries = max;
        return this;
    }

    public RetryConfigBuilder retryIndefinitely() {
        if (this.maxNumberOfTries != null) {
            throw new InvalidRetryConfigException(ALREADY_SPECIFIED_NUMBER_OF_TRIES__ERROR_MSG);
        }
        this.maxNumberOfTries = Integer.MAX_VALUE;
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(Duration duration) {
        if (duration.isNegative()) {
            throw new InvalidRetryConfigException(SHOULD_SPECIFY_DELAY_BETWEEN_RETRIES_AS_POSTIVE__ERROR_MSG);
        }
        this.delayBetweenRetries = duration;
        return this;
    }

    public RetryConfigBuilder withDelayBetweenTries(long amount, ChronoUnit time) {
        this.delayBetweenRetries = Duration.of(amount, time);
        return this;
    }

    public RetryConfigBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = backoffStrategy;
        return this;
    }

    public RetryConfigBuilder withFixedBackoff() {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = new FixedBackoffStrategy();
        return this;
    }

    public RetryConfigBuilder withExponentialBackoff() {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = new ExponentialBackoffStrategy();
        return this;
    }

    public RetryConfigBuilder withFibonacciBackoff() {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = new FibonacciBackoffStrategy();
        return this;
    }

    public RetryConfigBuilder withNoWaitBackoff() {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = new NoWaitBackoffStrategy();
        return this;
    }

    public RetryConfigBuilder withRandomBackoff() {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = new RandomBackoffStrategy();
        return this;
    }

    public RetryConfigBuilder withRandomExponentialBackoff() {
        this.validateBackoffStrategyAddition();
        this.backoffStrategy = new RandomExponentialBackoffStrategy();
        return this;
    }

    public RetryConfig build() {
        RetryConfig retryConfig = new RetryConfig(this.retryOnAnyException, this.retryOnSpecificExceptions, this.retryOnAnyExceptionExcluding, this.maxNumberOfTries, this.delayBetweenRetries, this.backoffStrategy, this.valueToRetryOn, this.retryOnValue, this.customRetryOnLogic, this.retryOnCausedBy);
        this.validateConfig(retryConfig);
        return retryConfig;
    }

    private void validateConfig(RetryConfig retryConfig) {
        if (!this.validationEnabled) {
            return;
        }
        if (null == retryConfig.getBackoffStrategy()) {
            throw new InvalidRetryConfigException(MUST_SPECIFY_BACKOFF__ERROR_MSG);
        }
        if (null == retryConfig.getMaxNumberOfTries()) {
            throw new InvalidRetryConfigException(MUST_SPECIFY_MAX_TRIES__ERROR_MSG);
        }
        if (null != retryConfig.getCustomRetryOnLogic() && this.builtInExceptionStrategySpecified) {
            throw new InvalidRetryConfigException(CAN_ONLY_SPECIFY_CUSTOM_EXCEPTION_STRAT__ERROR_MSG);
        }
        this.backoffStrategy.validateConfig(retryConfig);
    }

    private void validateBackoffStrategyAddition() {
        if (!this.validationEnabled) {
            return;
        }
        if (null != this.backoffStrategy) {
            throw new InvalidRetryConfigException(CAN_ONLY_SPECIFY_ONE_BACKOFF_STRAT__ERROR_MSG);
        }
    }

    private void validateExceptionStrategyAddition() {
        if (!this.validationEnabled) {
            return;
        }
        if (this.builtInExceptionStrategySpecified) {
            throw new InvalidRetryConfigException(CAN_ONLY_SPECIFY_ONE_EXCEPTION_STRAT__ERROR_MSG);
        }
    }

    public RetryConfigBuilder fixedBackoff5Tries10Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(5).withDelayBetweenTries(10L, ChronoUnit.SECONDS).withFixedBackoff();
    }

    public RetryConfigBuilder exponentialBackoff5Tries5Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(5).withDelayBetweenTries(5L, ChronoUnit.SECONDS).withExponentialBackoff();
    }

    public RetryConfigBuilder fiboBackoff7Tries5Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(7).withDelayBetweenTries(5L, ChronoUnit.SECONDS).withFibonacciBackoff();
    }

    public RetryConfigBuilder randomExpBackoff10Tries60Sec() {
        return new RetryConfigBuilder().retryOnAnyException().withMaxNumberOfTries(10).withDelayBetweenTries(60L, ChronoUnit.SECONDS).withRandomExponentialBackoff();
    }
}

