/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.runtime.utils;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.runtime.utils.MuleArtifactLoaderDescriptor;
import org.mule.munit.remote.runtime.utils.MuleVersion;
import org.mule.munit.remote.runtime.utils.Product;

public abstract class AbstractMuleArtifactModel {
    public static final String NAME = "name";
    public static final String REQUIRED_PRODUCT = "requiredProduct";
    public static final String MIN_MULE_VERSION = "minMuleVersion";
    public static final String ID = "id";
    public static final String CLASS_LOADER_MODEL_LOADER_DESCRIPTOR = "classLoaderModelLoaderDescriptor";
    public static final String BUNDLE_DESCRIPTOR_LOADER = "bundleDescriptorLoader";
    private static final String MANDATORY_FIELD_MISSING_MESSAGE = "Invalid artifact descriptor: \"%s\". Mandatory field \"%s\" is missing or has an invalid value. %s";
    private static final String CLASS_LOADER_MODEL_LOADER_DESCRIPTOR_ID = "classLoaderModelLoaderDescriptorid";
    private static final String BUNDLE_DESCRIPTOR_LOADER_ID = "bundleDescriptorLoaderid";
    private String name;
    private String minMuleVersion;
    private Product requiredProduct;
    private MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor;
    private MuleArtifactLoaderDescriptor bundleDescriptorLoader;

    protected AbstractMuleArtifactModel(String name, String minMuleVersion, Product requiredProduct, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        Preconditions.checkArgument(classLoaderModelLoaderDescriptor != null, "classLoaderModelLoaderDescriptor cannot be null");
        Preconditions.checkArgument(bundleDescriptorLoader != null, "bundleDescriptorLoader cannot be null");
        Preconditions.checkArgument(minMuleVersion == null || new MuleVersion(minMuleVersion).getRevision() != -1, "descriptor minMuleVersion must have patch version specified");
        this.minMuleVersion = minMuleVersion;
        this.name = name;
        this.requiredProduct = requiredProduct;
        this.classLoaderModelLoaderDescriptor = classLoaderModelLoaderDescriptor;
        this.bundleDescriptorLoader = bundleDescriptorLoader;
    }

    public AbstractMuleArtifactModel() {
    }

    public String getName() {
        return this.name;
    }

    public String getMinMuleVersion() {
        return this.minMuleVersion;
    }

    public void setMinMuleVersion(String minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
    }

    public Product getRequiredProduct() {
        return this.requiredProduct;
    }

    public MuleArtifactLoaderDescriptor getBundleDescriptorLoader() {
        return this.bundleDescriptorLoader;
    }

    public MuleArtifactLoaderDescriptor getClassLoaderModelLoaderDescriptor() {
        return this.classLoaderModelLoaderDescriptor;
    }

    public void validateModel(String descriptorName) {
        this.validateMandatoryFieldIsSet(descriptorName, this.name, NAME);
        this.validateMandatoryFieldIsSet(descriptorName, (Object)this.requiredProduct, REQUIRED_PRODUCT, String.format("Valid values are %s", String.join((CharSequence)", ", Arrays.stream(Product.values()).map(Enum::name).collect(Collectors.toList()))));
        this.validateMandatoryFieldIsSet(descriptorName, this.minMuleVersion, MIN_MULE_VERSION);
        this.validateMandatoryFieldIsSet(descriptorName, this.classLoaderModelLoaderDescriptor, CLASS_LOADER_MODEL_LOADER_DESCRIPTOR);
        this.validateMandatoryFieldIsSet(descriptorName, this.classLoaderModelLoaderDescriptor.getId(), CLASS_LOADER_MODEL_LOADER_DESCRIPTOR_ID);
        this.validateMandatoryFieldIsSet(descriptorName, this.bundleDescriptorLoader, BUNDLE_DESCRIPTOR_LOADER);
        this.validateMandatoryFieldIsSet(descriptorName, this.bundleDescriptorLoader.getId(), BUNDLE_DESCRIPTOR_LOADER_ID);
        this.doValidateCustomFields(descriptorName);
    }

    private void validateMandatoryFieldIsSet(String descriptorName, Object field, String fieldName, String extraErrorMessage) {
        Preconditions.checkState(field != null, String.format(MANDATORY_FIELD_MISSING_MESSAGE, descriptorName, fieldName, extraErrorMessage));
    }

    void validateMandatoryFieldIsSet(String descriptorName, Object field, String fieldName) {
        this.validateMandatoryFieldIsSet(descriptorName, field, fieldName, "");
    }

    void doValidateCustomFields(String descriptorName) {
    }
}

