/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.properties;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;

public class MUnitUserPropertiesManager {
    private static Properties initialSystemProperties;
    private static Set<String> notAllowedPropertyKeys;
    private Map<String, String> applicationProperties = new ConcurrentHashMap<String, String>();

    public MUnitUserPropertiesManager() {
        MUnitUserPropertiesManager.storeInitialSystemProperties();
    }

    public static void storeInitialSystemProperties() {
        initialSystemProperties = (Properties)System.getProperties().clone();
    }

    public static void restoreInitialSystemProperties() {
        System.setProperties(initialSystemProperties);
    }

    public static void addUserPropertiesToSystem(Map<String, Object> userProperties) {
        if (userProperties != null) {
            for (Map.Entry<String, Object> entry : userProperties.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    MUnitUserPropertiesManager.createProperty(entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                MUnitUserPropertiesManager.addUserPropertyToSystem(entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static void createProperty(String key, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (entry.getValue() instanceof String) {
                MUnitUserPropertiesManager.addUserPropertyToSystem(key + "." + entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            MUnitUserPropertiesManager.createProperty(key + "." + entry.getKey(), (Map)entry.getValue());
        }
    }

    public static void addUserPropertyToSystem(String key, String value) {
        Validate.notBlank(key, "The property key must not be null nor empty", new Object[0]);
        if (MUnitUserPropertiesManager.isPropertyKeyAllowed(key).booleanValue()) {
            System.setProperty(key, value);
        }
    }

    public static void loadPropertiesToSystem(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> System.setProperty((String)k, (String)v)));
    }

    public static boolean hasSystemProperty(String key) {
        return System.getProperty(key) != null;
    }

    public static boolean hasEnvironmentProperty(String key) {
        return System.getenv(key) != null;
    }

    private static Boolean isPropertyKeyAllowed(String key) {
        return !notAllowedPropertyKeys.contains(key);
    }

    private static Set<String> defineNotAllowedPropertyKeys() {
        HashSet<String> propertyKeysSet = new HashSet<String>();
        propertyKeysSet.add("java.library.path");
        propertyKeysSet.add("file.encoding");
        propertyKeysSet.add("jdk.map.althashing.threshold");
        return propertyKeysSet;
    }

    public void addApplicationProperty(String key, String value) {
        Validate.notBlank(key, "The property key must not be null nor empty", new Object[0]);
        if (MUnitUserPropertiesManager.isPropertyKeyAllowed(key).booleanValue()) {
            this.applicationProperties.put(key, value);
            System.setProperty(key, value);
        }
    }

    public Map<String, String> getApplicationProperties() {
        HashMap<String, String> appProp = new HashMap<String, String>();
        appProp.putAll(this.applicationProperties);
        return appProp;
    }

    public static void removeProperties(Map<String, Object> systemProperties) {
        if (systemProperties != null) {
            for (Map.Entry<String, Object> entry : systemProperties.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    MUnitUserPropertiesManager.removeProperty(entry.getKey(), (Map)entry.getValue());
                    continue;
                }
                MUnitUserPropertiesManager.removeUserPropertyFromSystem(entry.getKey());
            }
        }
    }

    private static void removeProperty(String key, Map<String, Object> value) {
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            if (entry.getValue() instanceof String) {
                MUnitUserPropertiesManager.removeUserPropertyFromSystem(key + "." + entry.getKey());
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            MUnitUserPropertiesManager.removeProperty(key + "." + entry.getKey(), (Map)entry.getValue());
        }
    }

    private static void removeUserPropertyFromSystem(String key) {
        System.clearProperty(key);
    }

    static {
        notAllowedPropertyKeys = MUnitUserPropertiesManager.defineNotAllowedPropertyKeys();
    }
}

