/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciitable.v2.render;

import de.vandermeer.asciitable.v2.V2_AsciiTable;
import de.vandermeer.asciitable.v2.render.V2_Width;

public class WidthAbsoluteEven
implements V2_Width {
    protected int width;

    public WidthAbsoluteEven(int width) {
        if (width >= 3) {
            this.width = width;
        }
    }

    @Override
    public int[] getColumnWidths(V2_AsciiTable table) {
        int borders;
        if (table == null) {
            return null;
        }
        int colNumber = table.getColumnCount();
        int[] ret = new int[colNumber];
        int content = 0;
        content = table.getDefaultPadding() > 0 ? colNumber * table.getDefaultPadding() + colNumber : colNumber * 3;
        if (this.width < content + (borders = colNumber + 1)) {
            throw new IllegalArgumentException("wrong width argument: width must allow for borders");
        }
        int distribute = this.width - 1 - colNumber;
        int colmin = distribute / colNumber;
        int leftover = distribute - colmin * colNumber;
        for (int i = 0; i < colNumber; ++i) {
            ret[i] = colmin;
            if (leftover == 0) continue;
            int n = i;
            ret[n] = ret[n] + 1;
            --leftover;
        }
        return ret;
    }
}

