/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.embedded.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.BundleDependenciesResolutionException;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.jpms.api.MultiLevelClassLoaderFactory;
import org.mule.runtime.module.embedded.api.dependencies.MuleDependenciesResolver;
import org.mule.runtime.module.embedded.internal.MavenContainerClassLoaderFactory;
import org.mule.runtime.module.embedded.internal.RuntimeProduct;
import org.mule.runtime.module.embedded.internal.utils.DependenciesUtils;

public class MavenContainerOptSeparateClassLoaderFactory
extends MavenContainerClassLoaderFactory {
    private static final String ARTIFACT_INFO_PROPERTIES = "artifact-info.properties";
    private final MavenClient mavenClient;
    private final RuntimeProduct runtimeProduct;
    private final boolean isolate;

    public MavenContainerOptSeparateClassLoaderFactory(MuleDependenciesResolver muleDependenciesResolver, MavenClient mavenClient, RuntimeProduct runtimeProduct, boolean isolate) {
        super(muleDependenciesResolver);
        this.mavenClient = mavenClient;
        this.runtimeProduct = runtimeProduct;
        this.isolate = isolate;
    }

    @Override
    public ClassLoader create(URL containerBaseFolder) {
        try {
            File containerFolderFile = FileUtils.toFile((URL)containerBaseFolder);
            URL configurationFolderUrl = new URL(new File(containerFolderFile, "conf").toURI() + "/");
            ClassLoader referenceClassLoader = this.getReferenceClassLoader(this.runtimeProduct);
            URLClassLoader parentClassLoader = new URLClassLoader(Collections.singletonList(configurationFolderUrl).toArray(new URL[1]), this.buildParentClassLoader(referenceClassLoader));
            return JpmsUtils.createModuleLayerClassLoader((URL[])this.getMuleDependenciesResolver().resolveOptLibs().toArray(new URL[0]), (URL[])this.getMuleDependenciesResolver().resolveMuleLibs().toArray(new URL[0]), (MultiLevelClassLoaderFactory)MultiLevelClassLoaderFactory.MULTI_LEVEL_URL_CLASSLOADER_FACTORY, (ClassLoader)parentClassLoader, Optional.of(this.getReferenceClass(this.runtimeProduct, referenceClassLoader)));
        }
        catch (BundleDependenciesResolutionException e) {
            throw new IllegalArgumentException("Could not find embedded container bom artifact", e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getReferenceClassLoader(RuntimeProduct runtimeProduct) {
        if (runtimeProduct.isSupportsIsolation() && this.isolate) {
            return JpmsUtils.createModuleLayerClassLoader((URL[])new URL[]{this.getEmbeddedCommons()}, (ClassLoader)ClassLoader.getSystemClassLoader().getParent());
        }
        return this.getClass().getClassLoader();
    }

    private Class<?> getReferenceClass(RuntimeProduct runtimeProduct, ClassLoader referenceClassLoader) {
        if (runtimeProduct.isSupportsIsolation() && this.isolate) {
            return this.getEmbeddedCommonsClass(referenceClassLoader);
        }
        return this.getClass();
    }

    private Class<?> getEmbeddedCommonsClass(ClassLoader commonsClassLoader) {
        try {
            return commonsClassLoader.loadClass("org.mule.runtime.module.embedded.commons.api.ArtifactConfiguration");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private URL getEmbeddedCommons() {
        BundleDescriptor embeddedCommonsBundleDescriptor = new BundleDescriptor.Builder().setGroupId("org.mule.runtime").setArtifactId("mule-embedded-commons").setVersion(this.getImplementationVersion()).setType("jar").build();
        return DependenciesUtils.dependencyToUrl().apply((BundleDependency)this.mavenClient.resolveBundleDescriptor(embeddedCommonsBundleDescriptor));
    }

    private String getImplementationVersion() {
        try {
            Properties artifactInfo = new Properties();
            artifactInfo.load(this.getClass().getClassLoader().getResourceAsStream(ARTIFACT_INFO_PROPERTIES));
            return artifactInfo.getProperty("artifact-version");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

