/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.maven.client.internal.ApiDependencyGraphTransformer;
import org.mule.maven.client.internal.MulePluginDependencyGraphTransformer;

public class OneInstancePerNodeGraphTransformer
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        this.rebuildIsolatedDependencies(node, Collections.newSetFromMap(new IdentityHashMap()));
        return node;
    }

    private void rebuildIsolatedDependencies(DependencyNode node, Set<DependencyNode> visited) {
        LinkedList<DependencyNode> newChildren = new LinkedList<DependencyNode>();
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        for (DependencyNode child : node.getChildren()) {
            if (MulePluginDependencyGraphTransformer.isPlugin(child) || ApiDependencyGraphTransformer.isApi(child)) {
                newChildren.add(this.copy(child, new CopyContext(child)));
                continue;
            }
            this.rebuildIsolatedDependencies(child, visited);
            newChildren.add(child);
        }
        node.setChildren(newChildren);
    }

    private DependencyNode copy(DependencyNode node, CopyContext context) {
        return context.get(node).orElseGet(() -> {
            DefaultDependencyNode copyNode = new DefaultDependencyNode(node);
            context.register(node, copyNode);
            copyNode.setChildren(node.getChildren().stream().map(c -> {
                if (context.shouldCopy(c)) {
                    return this.copy((DependencyNode)c, context.getContextFor(c));
                }
                return c;
            }).collect(Collectors.toList()));
            return copyNode;
        });
    }

    private static class CopyContext {
        private final Map<DependencyNode, DependencyNode> globalCache;
        private final Map<DependencyNode, DependencyNode> localCache;
        private final Predicate<DependencyNode> copyStrategy;

        private CopyContext(DependencyNode parentNode) {
            this(parentNode, new IdentityHashMap<DependencyNode, DependencyNode>(), new IdentityHashMap<DependencyNode, DependencyNode>());
        }

        private CopyContext(DependencyNode parentNode, Map<DependencyNode, DependencyNode> globalCache, Map<DependencyNode, DependencyNode> localCache) {
            this.copyStrategy = this.getCopyStrategy(parentNode);
            this.globalCache = globalCache;
            this.localCache = localCache;
        }

        private Predicate<DependencyNode> getCopyStrategy(DependencyNode parentNode) {
            if (ApiDependencyGraphTransformer.isApi(parentNode)) {
                return ApiDependencyGraphTransformer::isApi;
            }
            return d -> true;
        }

        private Optional<DependencyNode> get(DependencyNode node) {
            if (this.globalCache.containsKey(node)) {
                return Optional.ofNullable(this.globalCache.get(node));
            }
            if (this.localCache.containsKey(node)) {
                return Optional.ofNullable(this.localCache.get(node));
            }
            return Optional.empty();
        }

        private void register(DependencyNode originalNode, DependencyNode copyNode) {
            if (MulePluginDependencyGraphTransformer.isPlugin(originalNode) || ApiDependencyGraphTransformer.isApi(originalNode)) {
                this.globalCache.put(originalNode, copyNode);
            } else {
                this.localCache.put(originalNode, copyNode);
            }
        }

        private CopyContext getContextFor(DependencyNode node) {
            if (MulePluginDependencyGraphTransformer.isPlugin(node)) {
                return new CopyContext(node, this.globalCache, new IdentityHashMap<DependencyNode, DependencyNode>());
            }
            return this;
        }

        private boolean shouldCopy(DependencyNode dependencyNode) {
            return this.copyStrategy.test(dependencyNode);
        }
    }
}

