/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.MavenConfiguration;
import org.mule.munit.remote.api.configuration.ServerPluginConfiguration;

public class EmbeddedContainerConfiguration
extends ContainerConfiguration {
    private MavenConfiguration mavenConfiguration;
    private List<ServerPluginConfiguration> serverPluginConfigurations;

    protected EmbeddedContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath, String log4JConfigurationFilePath, MavenConfiguration mavenConfiguration, List<ServerPluginConfiguration> serverPluginConfigurations, Map<String, String> systemPropertyVariables, Map<String, String> environmentVariables) {
        super(runtimeId, product, munitWorkingDirectoryPath, log4JConfigurationFilePath, systemPropertyVariables, environmentVariables);
        this.mavenConfiguration = mavenConfiguration;
        this.serverPluginConfigurations = serverPluginConfigurations;
    }

    public EmbeddedContainerConfiguration() {
    }

    public MavenConfiguration getMavenConfiguration() {
        return this.mavenConfiguration;
    }

    public List<ServerPluginConfiguration> getServerPluginConfigurations() {
        return this.serverPluginConfigurations;
    }

    public static class EmbeddedContainerConfigurationBuilder
    implements ContainerConfiguration.ContainerConfigurationBuilder {
        private String runtimeId;
        private String product;
        private String munitWorkingDirectoryPath;
        private String log4JConfigurationFilePath;
        private MavenConfiguration mavenConfiguration;
        private List<ServerPluginConfiguration> serverPluginConfigurations = new ArrayList<ServerPluginConfiguration>();
        private Map<String, String> systemPropertyVariables;
        private Map<String, String> environmentVariables;

        public static EmbeddedContainerConfigurationBuilder from(EmbeddedContainerConfiguration cc) {
            EmbeddedContainerConfigurationBuilder builder = new EmbeddedContainerConfigurationBuilder();
            builder.withLog4JConfigurationFilePath(cc.getLog4JConfigurationFilePath());
            builder.withMavenConfiguration(cc.getMavenConfiguration());
            cc.getServerPluginConfigurations().forEach(spc -> builder.withServerPluginConfiguration((ServerPluginConfiguration)spc));
            builder.withProduct(cc.getProduct());
            builder.withRuntimeId(cc.getRuntimeId());
            builder.withMunitWorkingDirectoryPath(cc.getMunitWorkingDirectoryPath());
            return builder;
        }

        public EmbeddedContainerConfigurationBuilder withRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withProduct(String product) {
            this.product = product;
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withMunitWorkingDirectoryPath(String munitWorkingDirectoryPath) {
            this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withLog4JConfigurationFilePath(String log4JConfigurationFilePath) {
            this.log4JConfigurationFilePath = log4JConfigurationFilePath;
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
            this.mavenConfiguration = mavenConfiguration;
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withServerPluginConfiguration(ServerPluginConfiguration serverPluginConfiguration) {
            this.serverPluginConfigurations.add(serverPluginConfiguration);
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
            this.systemPropertyVariables = systemPropertyVariables;
            return this;
        }

        public EmbeddedContainerConfigurationBuilder withEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        @Override
        public EmbeddedContainerConfiguration build() {
            return new EmbeddedContainerConfiguration(this.runtimeId, this.product, this.munitWorkingDirectoryPath, this.log4JConfigurationFilePath, this.mavenConfiguration, this.serverPluginConfigurations, this.systemPropertyVariables, this.environmentVariables);
        }
    }
}

