/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.mule.munit.common.util.Preconditions;

public class Collections {
    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... elements) {
        HashSet set = new HashSet(elements.length);
        java.util.Collections.addAll(set, elements);
        return set;
    }

    public static <T> HashSet<T> newHashSet(Set<? extends T> elements) {
        HashSet<T> set = new HashSet<T>(elements.size());
        set.addAll(elements);
        return set;
    }

    public static <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator) {
        Preconditions.checkNotNull(comparator, "Comparator must not be null");
        return new TreeSet<T>(comparator);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return java.util.Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return java.util.Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return java.util.Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        HashMap<K, V> map = new HashMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return java.util.Collections.unmodifiableMap(map);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        T current;
        if (iterable instanceof List) {
            List list = (List)iterable;
            if (list.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)list.get(list.size() - 1);
        }
        Iterator<T> iterator = iterable.iterator();
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    private Collections() {
    }
}

