/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.tool.verify;

import java.util.List;
import java.util.Map;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.behavior.ProcessorId;
import org.mule.munit.common.exception.MunitFail;
import org.mule.munit.mock.tool.AbstractMockingTool;
import org.mule.runtime.api.artifact.Registry;

public class Verifier
extends AbstractMockingTool {
    public Verifier(Registry registry) {
        super(registry);
    }

    public Verifier verifyCallOfProcessor(String name) {
        this.processorName = name;
        return this;
    }

    public Verifier ofNamespace(String namespace) {
        this.processorNamespace = namespace;
        return this;
    }

    public Verifier withAttributes(Map<String, Object> attributes) {
        this.processorAttributes = attributes;
        return this;
    }

    public void times(Integer times) {
        List<ProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.size() != times.intValue()) {
            MunitFail.fail((String)("On " + this.getFullName() + ". Expected " + times + " but got " + executedCalls.size() + " calls"));
        }
    }

    public void atLeast(Integer atLeast) {
        this.checkValidQuery();
        List<ProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.size() < atLeast) {
            MunitFail.fail((String)("On " + this.getFullName() + ". Expected at least " + atLeast + " but got " + executedCalls.size() + " calls"));
        }
    }

    public void atMost(Integer atMost) {
        this.checkValidQuery();
        List<ProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.size() > atMost) {
            MunitFail.fail((String)("On " + this.getFullName() + ". Expected at most " + atMost + " but got " + executedCalls.size() + " calls"));
        }
    }

    public void between(Integer atLeast, Integer atMost) {
        this.checkValidQuery();
        Integer numberOfExecutedCalls = this.getExecutedCalls().size();
        if (numberOfExecutedCalls < atLeast || numberOfExecutedCalls > atMost) {
            String failureMessage = String.format("On %s. Expected to be called between %s and %s times but got %s calls", this.getFullName(), atLeast, atMost, numberOfExecutedCalls);
            MunitFail.fail((String)failureMessage);
        }
    }

    public void atLeastOnce() {
        this.checkValidQuery();
        List<ProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.isEmpty()) {
            MunitFail.fail((String)("On " + this.getFullName() + ".It was never called"));
        }
    }

    private List<ProcessorCall> getExecutedCalls() {
        return this.getManager().findCallsFor(new ProcessorId(this.processorName, this.processorNamespace), this.processorAttributes);
    }
}

