/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.structure;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.plugin.maven.project.ApplicationStructureGenerator;
import org.mule.munit.plugin.maven.project.DomainStructureGenerator;
import org.mule.munit.plugin.maven.util.MuleApplicationDependencyFinder;
import org.mule.munit.remote.FolderNames;
import org.mule.munit.remote.api.configuration.RunConfiguration;

public class WorkingDirectoryGenerator {
    protected Log log;
    private ApplicationStructureGenerator structureGenerator;
    private MavenProject project;
    private String dirTimestamp;
    private String destinationName;
    private File workingDirectory;
    private Path generatedDomainStructurePath;
    private Path generatedApplicationStructurePath;

    public WorkingDirectoryGenerator(Log log, ApplicationStructureGenerator applicationStructureGenerator, MavenProject project) {
        Preconditions.checkArgument((log != null ? 1 : 0) != 0, (String)"Log must not be null");
        Preconditions.checkArgument((applicationStructureGenerator != null ? 1 : 0) != 0, (String)"Application structure generator must not be null");
        Preconditions.checkArgument((project != null ? 1 : 0) != 0, (String)"Project must not be null");
        this.log = log;
        this.project = project;
        this.structureGenerator = applicationStructureGenerator;
        this.dirTimestamp = Long.toString(System.nanoTime());
        this.destinationName = project.getArtifactId();
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public Path generate(RunConfiguration runConfiguration) throws MojoExecutionException {
        this.deleteDirectories();
        Path path = this.generateWorkingDirectory();
        this.generateApplicationStructure(runConfiguration);
        this.generateDomainStructure();
        return path;
    }

    public Path generateWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = new File(this.project.getBuild().getDirectory(), FolderNames.MUNIT_WORKING_DIR.value() + "-" + this.dirTimestamp);
        }
        return this.workingDirectory.toPath();
    }

    public Path generateApplicationStructure(RunConfiguration runConfiguration) throws MojoExecutionException {
        if (this.generatedApplicationStructurePath == null) {
            Path destinationPath = this.generateWorkingDirectory();
            try {
                this.log.debug((CharSequence)("Attempting to create application structure destination: " + destinationPath));
                this.generatedApplicationStructurePath = this.structureGenerator.generate(destinationPath.resolve(this.destinationName), runConfiguration);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Fail to create application structure", e);
            }
        }
        return this.generatedApplicationStructurePath;
    }

    public Optional<Path> generateDomainStructure() throws MojoExecutionException {
        Optional<Artifact> domainArtifact;
        if (this.generatedDomainStructurePath == null && (domainArtifact = this.getMuleApplicationDependencyFinder().findMuleDomainArtifact()).isPresent()) {
            File domainFile = domainArtifact.get().getFile();
            try {
                this.log.debug((CharSequence)("Attempting to create domain structure source: " + domainFile.getAbsolutePath() + " - destination: " + this.generateWorkingDirectory()));
                this.generatedDomainStructurePath = this.getDomainStructureGenerator(domainArtifact, domainFile).generate();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Fail to create domain structure", e);
            }
        }
        return Optional.ofNullable(this.generatedDomainStructurePath);
    }

    public void deleteDirectories() {
        Optional.ofNullable(this.workingDirectory).ifPresent(FileUtils::deleteQuietly);
        Optional.ofNullable(this.generatedDomainStructurePath).map(Path::toFile).ifPresent(FileUtils::deleteQuietly);
        Optional.ofNullable(this.generatedApplicationStructurePath).map(Path::toFile).ifPresent(FileUtils::deleteQuietly);
        this.workingDirectory = null;
        this.generatedDomainStructurePath = null;
        this.generatedApplicationStructurePath = null;
    }

    protected MuleApplicationDependencyFinder getMuleApplicationDependencyFinder() {
        return new MuleApplicationDependencyFinder(this.project);
    }

    protected DomainStructureGenerator getDomainStructureGenerator(Optional<Artifact> domainArtifact, File domainFile) {
        String domainName = domainArtifact.get().getArtifactId() + "-" + domainArtifact.get().getBaseVersion() + "-" + domainArtifact.get().getClassifier();
        return new DomainStructureGenerator(domainFile.toPath(), this.generateWorkingDirectory(), domainName);
    }
}

