/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarFileFactory {
    private static final String MANIFEST_VERSION = "1.0";

    public File create(List<String> classPath, String startClassName, File buildDirectory, String fileName) throws IOException {
        File file = new File(buildDirectory, fileName);
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try (JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);){
            jarOutputStream.setLevel(0);
            JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
            jarOutputStream.putNextEntry(je);
            Manifest manifest = new Manifest();
            StringBuilder cp = new StringBuilder();
            for (String el : classPath) {
                cp.append(new File(el).toURI().toURL().toExternalForm()).append(" ");
            }
            manifest.getMainAttributes().putValue("Manifest-Version", MANIFEST_VERSION);
            manifest.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            manifest.getMainAttributes().putValue("Main-Class", startClassName);
            manifest.write(jarOutputStream);
        }
        return file;
    }
}

