/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugin.maven.runner.model.TestResult;

public class SuiteResult {
    private String suitePath;
    private boolean suiteFinished = false;
    private boolean runtimeStartFailed = false;
    private String cause;
    private Map<String, TestResult> tests = new HashMap<String, TestResult>();
    private long time;
    private boolean suiteFailed;
    private boolean suiteError;
    private String parameterization;

    public void setRuntimeStartFailed(boolean runtimeStartFailed) {
        this.runtimeStartFailed = runtimeStartFailed;
    }

    public void setCause(String newCause) {
        if (StringUtils.isEmpty((CharSequence)this.cause)) {
            this.cause = newCause;
        }
    }

    public void add(String testName, TestResult testResult) {
        this.tests.put(testName, testResult);
    }

    public void setSuitePath(String suitePath) {
        this.suitePath = suitePath;
    }

    public void setSuiteFinished(boolean suiteFinished) {
        this.suiteFinished = suiteFinished;
    }

    public boolean isSuiteFinished() {
        return this.suiteFinished;
    }

    public boolean isRuntimeStartFailed() {
        return this.runtimeStartFailed;
    }

    public String getCause() {
        return this.cause;
    }

    public int getNumberOfProcessedTests() {
        return this.countTests(TestResult::isFinished);
    }

    public int getNumberOfIgnores() {
        return this.countTests(TestResult::isIgnored);
    }

    public int getNumberOfFailures() {
        if (this.isSuiteFailed()) {
            return 1;
        }
        return this.countTests(TestResult::hasFailed);
    }

    public int getNumberOfErrors() {
        if (this.isSuiteError()) {
            return 1;
        }
        return this.countTests(TestResult::hasError);
    }

    public int getNumberOfTests() {
        if (this.isSuiteFailed() || this.isSuiteError()) {
            return 1;
        }
        return this.tests.size();
    }

    public TestResult getTest(String string) {
        return this.tests.get(string);
    }

    public Optional<TestResult> getRunningTest() {
        return this.tests.values().stream().filter(test -> !test.isFinished()).findFirst();
    }

    public Collection<TestResult> getTests() {
        return this.tests.values();
    }

    public String getSuitePath() {
        return this.suitePath;
    }

    public boolean hasFailed() {
        return this.suiteFailed || this.findAnyTest(TestResult::hasFailed);
    }

    public boolean hasError() {
        return this.runtimeStartFailed || this.suiteError || this.findAnyTest(TestResult::hasError);
    }

    public boolean isIgnored() {
        return !this.tests.isEmpty() && this.tests.values().stream().allMatch(TestResult::isIgnored);
    }

    public List<TestResult> getFailingTests() {
        return this.filterTests(TestResult::hasFailed);
    }

    public List<TestResult> getErrorTests() {
        return this.filterTests(TestResult::hasError);
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setSuiteFailed(boolean suiteFailed) {
        this.suiteFailed = suiteFailed;
    }

    public boolean isSuiteFailed() {
        return this.suiteFailed;
    }

    public void setSuiteError(boolean suiteError) {
        this.suiteError = suiteError;
    }

    public boolean isSuiteError() {
        return this.suiteError;
    }

    public void setParameterization(String parameterization) {
        this.parameterization = parameterization;
    }

    public Optional<String> getParameterization() {
        return StringUtils.isNotBlank((CharSequence)this.parameterization) ? Optional.of(this.parameterization) : Optional.empty();
    }

    private int countTests(Predicate<TestResult> predicate) {
        return (int)this.tests.values().stream().filter(predicate).count();
    }

    private boolean findAnyTest(Predicate<TestResult> predicate) {
        return this.tests.values().stream().anyMatch(predicate);
    }

    private List<TestResult> filterTests(Predicate<TestResult> predicate) {
        return this.tests.values().stream().filter(predicate).collect(Collectors.toList());
    }
}

