/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.report.xml;

import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;

public class CdataAwareXppDriver
extends XppDriver {
    private static final List<String> CDATA_FIELDS = new ArrayList<String>();

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out){
            boolean cdata;
            {
                this.cdata = false;
            }

            public void startNode(String name) {
                super.startNode(name);
                this.cdata = CDATA_FIELDS.contains(name);
            }

            protected void writeText(QuickWriter writer, String text) {
                if (this.cdata) {
                    writer.write("<![CDATA[");
                    writer.write(NumericEntityEscaper.below((int)32).translate((CharSequence)text));
                    writer.write("]]>");
                } else {
                    super.writeText(writer, text);
                }
            }
        };
    }

    static {
        CDATA_FIELDS.add("failure");
    }
}

