/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runtime;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.plugin.maven.runtime.Product;

public class DiscoverProduct {
    public static final String DISCOVER_PRODUCT = "discoverProducts.product";
    public static final String DISCOVER_PRODUCTS_INCLUDE_SNAPSHOTS = "discoverProducts.includeSnapshots";
    public static final String DISCOVER_PRODUCTS_MIN_VERSION = "discoverProducts.minMuleVersion";
    public static final String DISCOVER_PRODUCTS_SKIP = "discoverProducts.skip";
    public static final String DISCOVER_PRODUTCS_REPOSITORIES = "discoverProducts.runtimeRepositories";
    public static final String DISCOVER_PRODUCTS_LATEST_PATCHES = "discoverProducts.latestPatches";
    public static final String DISCOVER_PRODUCTS_REPOSITORIES_SEPARATOR = ",";
    private Product id;
    private String minVersion;
    private boolean includeSnapshots = false;
    private boolean skip = false;
    private boolean latestPatches = true;
    private List<String> repositories = Collections.emptyList();

    public DiscoverProduct() {
    }

    private DiscoverProduct(Product id, String minVersion, boolean includeSnapshots, boolean skip, List<String> repositories, boolean useLatestPatches) {
        this.id = id;
        this.minVersion = minVersion;
        this.includeSnapshots = includeSnapshots;
        this.skip = skip;
        this.repositories = repositories;
        this.latestPatches = useLatestPatches;
    }

    public Optional<String> getMinVersion() {
        return Optional.ofNullable(this.minVersion);
    }

    public Optional<Product> getProductId() {
        return Optional.ofNullable(this.id);
    }

    public boolean isIncludeSnapshots() {
        return this.includeSnapshots;
    }

    public boolean isSkipped() {
        return this.skip;
    }

    public boolean isUseLatestPatches() {
        return this.latestPatches;
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Product productId;
        private String minVersion;
        private boolean includeSnapshots = false;
        private boolean skip = false;
        private boolean useLatestPatches = true;
        private List<String> runtimeRepositories = Collections.emptyList();

        public Builder from(DiscoverProduct discoverProduct) {
            discoverProduct.getMinVersion().ifPresent(minVersion -> {
                this.minVersion = minVersion;
            });
            discoverProduct.getProductId().ifPresent(productId -> {
                this.productId = productId;
            });
            this.includeSnapshots = discoverProduct.isIncludeSnapshots();
            this.skip = discoverProduct.isSkipped();
            this.useLatestPatches = discoverProduct.isUseLatestPatches();
            this.runtimeRepositories = discoverProduct.getRepositories();
            return this;
        }

        public Builder withProductId(Product productId) {
            this.productId = productId;
            return this;
        }

        public Builder withMinVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public Builder includingSnapshots(Boolean includeSnapshots) {
            this.includeSnapshots = includeSnapshots;
            return this;
        }

        public Builder skip(Boolean skip) {
            this.skip = skip;
            return this;
        }

        public Builder useLatestPatches(Boolean useLatestPatches) {
            this.useLatestPatches = useLatestPatches;
            return this;
        }

        public Builder withRuntimeRepositories(List<String> runtimeRepositories) {
            this.runtimeRepositories = runtimeRepositories;
            return this;
        }

        public Builder withOverrides(Properties userProperties) {
            if (userProperties.containsKey(DiscoverProduct.DISCOVER_PRODUCTS_INCLUDE_SNAPSHOTS)) {
                this.includeSnapshots = Boolean.valueOf(userProperties.getProperty(DiscoverProduct.DISCOVER_PRODUCTS_INCLUDE_SNAPSHOTS));
            }
            if (userProperties.containsKey(DiscoverProduct.DISCOVER_PRODUCT)) {
                this.productId = Product.valueOf(userProperties.getProperty(DiscoverProduct.DISCOVER_PRODUCT));
            }
            if (userProperties.containsKey(DiscoverProduct.DISCOVER_PRODUCTS_MIN_VERSION)) {
                this.minVersion = userProperties.getProperty(DiscoverProduct.DISCOVER_PRODUCTS_MIN_VERSION);
            }
            if (userProperties.containsKey(DiscoverProduct.DISCOVER_PRODUCTS_SKIP)) {
                this.skip = Boolean.valueOf(userProperties.getProperty(DiscoverProduct.DISCOVER_PRODUCTS_SKIP));
            }
            if (userProperties.containsKey(DiscoverProduct.DISCOVER_PRODUTCS_REPOSITORIES)) {
                this.runtimeRepositories = Arrays.asList(StringUtils.split((String)userProperties.getProperty(DiscoverProduct.DISCOVER_PRODUTCS_REPOSITORIES), (String)DiscoverProduct.DISCOVER_PRODUCTS_REPOSITORIES_SEPARATOR));
            }
            if (userProperties.containsKey(DiscoverProduct.DISCOVER_PRODUCTS_LATEST_PATCHES)) {
                this.useLatestPatches = Boolean.valueOf(userProperties.getProperty(DiscoverProduct.DISCOVER_PRODUCTS_LATEST_PATCHES));
            }
            return this;
        }

        public DiscoverProduct build() {
            return new DiscoverProduct(this.productId, this.minVersion, this.includeSnapshots, this.skip, this.runtimeRepositories, this.useLatestPatches);
        }
    }
}

