/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.runner.printer.MavenResultPrinter;
import org.mule.munit.plugin.maven.runner.printer.ResultPrinter;
import org.mule.munit.plugin.maven.runner.printer.TestOutputFilePrinter;
import org.mule.munit.plugin.maven.runner.printer.TextResultFilePrinter;
import org.mule.munit.plugin.maven.runner.printer.XmlResultPrinter;
import org.mule.munit.plugin.maven.util.ResultPrinterFactory;

public class DefaultResultPrinterFactory
implements ResultPrinterFactory {
    protected Log log;
    private File testOutputDirectory;
    private File surefireReportsFolder;
    private Map<String, String> systemProperties;
    private boolean enableSurefireReports;
    private boolean redirectTestOutputToFile;

    public DefaultResultPrinterFactory(Log log) {
        this.log = log;
    }

    public DefaultResultPrinterFactory withSurefireReports(Boolean enableSurefireReports, File surefireReportsFolder, Map<String, String> systemProperties) {
        this.surefireReportsFolder = surefireReportsFolder;
        this.enableSurefireReports = enableSurefireReports;
        this.systemProperties = systemProperties;
        return this;
    }

    public DefaultResultPrinterFactory withTestOutputReports(Boolean redirectTestOutputToFile, File testOutputDirectory) {
        Preconditions.checkNotNull((Object)redirectTestOutputToFile, (Object)"Redirect Output to File property cannot be null");
        Preconditions.checkNotNull((Object)testOutputDirectory, (Object)"Test Output Directory cannot be null");
        this.redirectTestOutputToFile = redirectTestOutputToFile;
        this.testOutputDirectory = testOutputDirectory;
        return this;
    }

    @Override
    public List<ResultPrinter> create() {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new MavenResultPrinter(this.log));
        if (this.enableSurefireReports) {
            printers.addAll(this.getSurefireResultPrinters(this.redirectTestOutputToFile));
        }
        if (this.redirectTestOutputToFile) {
            printers.add(new TestOutputFilePrinter(this.testOutputDirectory, this.log));
        }
        return printers;
    }

    private List<ResultPrinter> getSurefireResultPrinters(Boolean redirectTestOutputToFile) {
        ArrayList<ResultPrinter> printers = new ArrayList<ResultPrinter>();
        printers.add(new XmlResultPrinter(this.surefireReportsFolder, this.systemProperties, this.log));
        printers.add(new TextResultFilePrinter(this.surefireReportsFolder, this.log));
        if (redirectTestOutputToFile.booleanValue()) {
            printers.add(new TestOutputFilePrinter(this.surefireReportsFolder, this.log));
        }
        return printers;
    }
}

