/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.locator;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class ExportedPackagesLocator {
    private File rootFolder;

    public ExportedPackagesLocator(File rootFolder) {
        Preconditions.checkArgument((rootFolder != null ? 1 : 0) != 0, (Object)"Resources folder cannot be null");
        this.rootFolder = rootFolder;
    }

    public Set<String> locate() {
        if (!this.rootFolder.exists()) {
            return Collections.emptySet();
        }
        return FileUtils.listFiles((File)this.rootFolder, null, (boolean)true).stream().map(resourceFile -> this.rootFolder.toURI().relativize(resourceFile.toURI())).map(this::getPackageFromFile).collect(Collectors.toSet());
    }

    private String getPackageFromFile(URI classUri) {
        Path folderPath = new File(classUri.getPath()).toPath();
        return Optional.ofNullable(folderPath.getParent()).map(folder -> folder.toString().replace(File.separatorChar, '.')).orElse("");
    }
}

