/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.munit.extension.maven.internal.generator.ExtensionApplicationStructureGenerator;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.tools.api.packager.archiver.MuleArchiver;

public class MuleSourcesApplicationGenerator {
    private ExtensionApplicationStructureGenerator structureGenerator;
    private MavenProject mavenProject;
    private String projectName;

    public MuleSourcesApplicationGenerator(String projectName, MavenProject mavenProject, ExtensionApplicationStructureGenerator structureGenerator) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectName), (Object)"Project name cannot be blank");
        Preconditions.checkArgument((mavenProject != null ? 1 : 0) != 0, (Object)"Maven Project cannot be null");
        Preconditions.checkArgument((structureGenerator != null ? 1 : 0) != 0, (Object)"Structure generator cannot be null");
        this.structureGenerator = structureGenerator;
        this.mavenProject = mavenProject;
        this.projectName = projectName;
    }

    public void generate(Path location, RunConfiguration runConfiguration) throws MojoExecutionException {
        try {
            this.structureGenerator.withArchiver(new MuleArchiver()).withSourcesFolder(this.mavenProject.getBasedir()).generate(location.resolve(String.format("%s.jar", this.projectName)), runConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to generate application with sources", e);
        }
    }
}

