/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator.maven;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.common.util.VersionUtils;
import org.mule.munit.extension.maven.internal.generator.maven.PomEnricher;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;
import org.mule.runtime.core.internal.util.JarUtils;
import org.mule.tools.api.packager.structure.FolderNames;

public class ApplicationPomGenerator {
    protected static final String APPLICATION_PACKAGING = "mule-application";
    protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    protected static final String EXTENSION_DEPENDENCY_SCOPE = "system";
    protected static final String MODEL_VERSION = "4.0.0";
    protected static final String TEST_APPLICATION_SUFFIX = "-test-application";
    public static final String TEST_SCOPE = "test";
    private static final List<String> APP_INCLUDED_SCOPES = Arrays.asList("test");
    private static final List<DependencyExclusion> BLACKLISTED_DEPENDENCIES = Arrays.asList(new DependencyExclusion("org.mule.tests.plugin", "mule-tests-component-plugin"));
    private static final String MULE_ARTIFACT_PATH_INSIDE_JAR = FolderNames.META_INF.value() + "/" + FolderNames.MULE_ARTIFACT.value();
    private static final String MULE_ARTIFACT_JSON_IN_JAR = MULE_ARTIFACT_PATH_INSIDE_JAR + "/" + "mule-artifact.json";
    private static final String MTF_TOOLS_MIN_MULE_VERSION = "4.2.0";
    private static final String MTF_TOOLS_GROUP_ID = "com.mulesoft.munit";
    private static final String MTF_TOOLS_ARTIFACT_ID = "mtf-tools";
    private final List<PomEnricher> pomEnrichers;
    private final String projectArtifactId;
    private final MavenProject project;
    private final String pluginArtifactId;
    private final Log log;

    public ApplicationPomGenerator(MavenProject project, List<PomEnricher> pomEnrichers, String projectArtifactId, String pluginArtifactId, Log log) {
        this.project = project;
        this.projectArtifactId = projectArtifactId;
        this.pluginArtifactId = pluginArtifactId;
        this.pomEnrichers = pomEnrichers;
        this.log = log;
    }

    public Model generate(RunConfiguration runConfiguration) {
        Model pomModel = new Model();
        this.setGeneralAttributes(pomModel);
        this.addDependencies(pomModel, runConfiguration);
        this.addPomEnrichers(pomModel);
        return pomModel;
    }

    private void setGeneralAttributes(Model pomModel) {
        pomModel.setGroupId(this.project.getGroupId());
        pomModel.setArtifactId(this.projectArtifactId);
        pomModel.setVersion(this.project.getVersion());
        pomModel.setPackaging(APPLICATION_PACKAGING);
        pomModel.setModelVersion(MODEL_VERSION);
    }

    private void addDependencies(Model pomModel, RunConfiguration runConfiguration) {
        this.addMUnitPluginDependencies(pomModel, runConfiguration);
        this.addExtensionAsDependency(pomModel);
        this.addFilteredDependencies(pomModel, runConfiguration);
    }

    private void addMUnitPluginDependencies(Model pomModel, RunConfiguration runConfiguration) {
        Plugin munitPlugin = this.project.getBuild().getPlugins().stream().filter(p -> p.getArtifactId().equals(this.pluginArtifactId)).findAny().orElseThrow(() -> new IllegalStateException("No [" + this.pluginArtifactId + "] defined in the extension pom.xml"));
        List dependencies = munitPlugin.getDependencies();
        if (dependencies != null) {
            dependencies.stream().filter(dep -> this.isMtfToolsSupported((Dependency)dep, runConfiguration)).forEach(dependency -> {
                Dependency newDependency = dependency.clone();
                newDependency.setScope(TEST_SCOPE);
                pomModel.addDependency(newDependency);
            });
        }
    }

    private boolean isMtfToolsSupported(Dependency dependency, RunConfiguration runConfiguration) {
        if (dependency.getGroupId().equals(MTF_TOOLS_GROUP_ID) && dependency.getArtifactId().equals(MTF_TOOLS_ARTIFACT_ID)) {
            String runtimeVersion = runConfiguration.getContainerConfiguration().getRuntimeId();
            boolean isAtLeastMtfToolsMinVersion = VersionUtils.isAtLeastMinMuleVersion((String)runtimeVersion, (String)MTF_TOOLS_MIN_MULE_VERSION);
            if (!isAtLeastMtfToolsMinVersion) {
                this.log.debug((CharSequence)("Excluded dependency " + dependency.getArtifactId() + " since it won't run against runtime " + runtimeVersion));
            }
            return isAtLeastMtfToolsMinVersion;
        }
        return true;
    }

    private void addExtensionAsDependency(Model pomModel) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(this.project.getGroupId());
        dependency.setArtifactId(this.project.getArtifactId());
        dependency.setVersion(this.project.getVersion());
        dependency.setSystemPath(this.getExtensionJarPath());
        dependency.setScope(EXTENSION_DEPENDENCY_SCOPE);
        dependency.setClassifier(MULE_PLUGIN_CLASSIFIER);
        pomModel.addDependency(dependency);
    }

    private String getExtensionJarPath() {
        String buildDir = this.project.getBuild().getDirectory();
        String path = buildDir + "/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + MULE_PLUGIN_CLASSIFIER + ".jar";
        if (!new File(path).exists()) {
            throw new IllegalStateException("Could not find module jar file, [" + path + "] does not exist.");
        }
        return path;
    }

    private void addPomEnrichers(Model pomModel) {
        this.pomEnrichers.forEach(pomEnricher -> pomEnricher.generate(pomModel));
    }

    private void addFilteredDependencies(Model pomModel, RunConfiguration runConfiguration) {
        this.project.getDependencies().stream().filter(dependency -> APP_INCLUDED_SCOPES.contains(dependency.getScope())).filter(this::isNotBlacklisted).filter(this.minMuleVersionCompatible(runConfiguration)).forEach(arg_0 -> ((Model)pomModel).addDependency(arg_0));
    }

    private Predicate<Dependency> minMuleVersionCompatible(RunConfiguration runConfiguration) {
        return dependency -> this.isMinMuleVersionCompatible(runConfiguration, (Dependency)dependency);
    }

    private boolean isMinMuleVersionCompatible(RunConfiguration runConfiguration, Dependency dependency) {
        String runtimeVersion = runConfiguration.getContainerConfiguration().getRuntimeId();
        boolean dependencyMinMuleVersionCompatible = this.isDependencyMinMuleVersionCompatible(dependency, runtimeVersion);
        if (!dependencyMinMuleVersionCompatible) {
            this.log.debug((CharSequence)("Excluded dependency " + dependency.getArtifactId() + " since it won't run against runtime " + runtimeVersion));
        }
        return dependencyMinMuleVersionCompatible;
    }

    private boolean isDependencyMinMuleVersionCompatible(Dependency dependency, String runtimeVersion) {
        if (!MULE_PLUGIN_CLASSIFIER.equals(dependency.getClassifier())) {
            return true;
        }
        Optional<Artifact> dependencyArtifact = this.lookupArtifact(dependency);
        return dependencyArtifact.map(this::getPluginModel).map(pluginModel -> VersionUtils.isAtLeastMinMuleVersion((String)runtimeVersion, (String)pluginModel.getMinMuleVersion())).orElse(true);
    }

    private MulePluginModel getPluginModel(Artifact artifact) {
        try {
            return JarUtils.loadFileContentFrom((File)artifact.getFile(), (String)MULE_ARTIFACT_JSON_IN_JAR).map(jsonContent -> {
                MulePluginModel pluginModel = (MulePluginModel)new MulePluginModelJsonSerializer().deserialize(new String((byte[])jsonContent));
                this.log.debug((CharSequence)("Found minMuleVersion" + pluginModel.getMinMuleVersion() + " for plugin" + pluginModel.getName()));
                return pluginModel;
            }).orElse(null);
        }
        catch (IOException e) {
            this.log.warn((CharSequence)("An error occurred while reading " + artifact.getArtifactId() + " mule-artifact.json file"), (Throwable)e);
            return null;
        }
    }

    private Optional<Artifact> lookupArtifact(Dependency dependency) {
        return this.project.getArtifacts().stream().filter(artifact -> artifact.getGroupId().equals(dependency.getGroupId())).filter(artifact -> artifact.getArtifactId().equals(dependency.getArtifactId())).findAny();
    }

    private boolean isNotBlacklisted(Dependency dependency) {
        return BLACKLISTED_DEPENDENCIES.stream().noneMatch(exclusion -> exclusion.excludes(dependency));
    }

    private static class DependencyExclusion {
        private String groupId;
        private String artifactId;

        DependencyExclusion(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        boolean excludes(Dependency dependency) {
            return this.groupId.equals(dependency.getGroupId()) && this.artifactId.equals(dependency.getArtifactId());
        }
    }
}

